/** Klasse die ein Tier repraesentiert. Mit einer Nummer fuer die Tierart,
    einer ID, einem Alter, der Ernaehrungssituation, ob ein kind_folgt, welche
    Richtung als naechstes eingeschlagen wird und einem frei benutzbarem Gencode
*/

/*
    Copyright (C) 2006 by Malte Marwedel    m.marwedel < AT > onlinehome.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*
type: 1 Steht fuer Wolf, 2 steht fuer Hase
id:   Eine fortlaufende Nummer - derzeit ohne Verwendung
init_done: Verhindert dass type oder id geaedert werden koennen
age:  Speichert das Hoechstalter der Tiere
hunger: Sobald der Hunger zu gross wird kann ein Tier sterben, wenn es etwas
      isst reduziert sich der Hunger
get_child: Wenn im naehstem Zyklus ein Kind erzeugt wird, so wird das hier
      vermerkt. Dies ist noetig um bei dem neuem Zyklus die richtige Menge
      Speicher zu reservieren
direction: In welche Richtung das Tier als naechstes laufen wird oder ob es
      stirbt. Noetig fuer die POV-Ray Grafikausgabe.
      N: Norden; O: Osten; W:Westen; S:Sden; H:Hier bleiben; D: Down/Sterben
genetable: Optional. Hier koenne das Verhalten der Tiere beeinflusst werden und
      die Gene mit minimaler Aenderung an die Nachkommen uebergeben werden, so
      dass sich angepasste Gene besser durchsetzen.

Jedes Tier benoeigt somit ~83 Byte Speicher. Bei 25000 Tieren wuerde dies bis zu
      2,1MB sein. Hinzu kommt eine kurzzeitige Verdopplung waehrend des
      Berechnens eines Zuges.
*/

package Tier;

public class Tier {
  private int id;      //ID - Fortlaufende Nummer
  private int type;    //1: Wolf, 2: Hase
  private boolean init_done = false;
  private int age;     //Alter in Zyklen
  private int hunger;  //Wie lange ist das letzte Mahl her
  private boolean get_child; //Bekommt Nachwuchs
  private char direction; //Welche Richtung (N,O,S,W,H,D) als naechstes kommt
  private int genetable[] = new int[16]; //Einige Erweiterungen fuer Experimente


  public Tier exact_clone() {
    //Erzeugt eine exakte Kopie des Tieres
    Tier t2 = new Tier();
    t2.id = this.id;
    t2.type = this.type;
    t2.init_done = this.init_done;
    t2.age = this.age;
    t2.hunger = this.hunger;
    t2.get_child = this.get_child;
    t2.direction = this.direction;
    t2.genetable = this.genetable;
    return t2;
  }

  public void make(int n_id, int n_type) {
    //Initialisiert das Tier
    if (this.init_done == false) {
      this.type = n_type;
      if ((n_type != 1) && (n_type != 2)) {
        System.out.println("Tier.make: Warning: n_type unknown");
      }
      this.id = n_id;
      if (n_id < 0) {
        System.out.println("Tier.make: Warning: n_id negative");
      }
      this.age = 0;
      this.hunger = 0;
      this.get_child = false;
      this.direction = 'H';
      for (int n = 0; n < this.genetable.length; n++) {
        this.genetable[n] = 0;
      }
      this.init_done = true;
    } else {
      System.out.println("Tier.make: Error: make() can be called only once");
    }
  }

  /* Fuer gewoehnlich wird aus einem Tier kein anderes, daher kein set_type */
  public int type_get() {
    return this.type;
  }

   //Die ID aendert sich nicht
  public int id_get() {
    return this.id;
  }

  //Das Alter des Tieres in Zyklen
  public int age_get() {
    return this.age;
  }

  //Alter erhoehen
  public void age_inc() {
    this.age++;
  }

  //Wieviel hunger hat das Tier
  public int hunger_get() {
    return this.hunger;
  }

  //Weniger Hunger
  public void hunger_reduce(int eaten) {
    if (eaten > this.hunger) {
      this.hunger = 0;
    } else {
      this.hunger -= eaten;
    }
  }

  //Mehr Hunger
  public void hunger_add(int more_hunger) {
    this.hunger += more_hunger;
  }

  //Ob das Tier ein Kind bekommt
  public boolean child_get() {
    return this.get_child;
  }

  //Kind bekommen setzen
  public void child_set(boolean n_state) {
    this.get_child = n_state;
  }

  //Wohin sich das Tier bewegt hat / bewegen soll
  public char direction_get() {
    return this.direction;
  }

  //Wohin sich das Tier bewegen soll
  public void direction_set(char next_direction) {
    this.direction = next_direction;
  }

  //Speicher fuer Erweiterungen auslesen
  public int gene_get(int gene_no) {
    if ((gene_no >= 0) && (gene_no < 16)) {
      return this.genetable[gene_no];
    } else {
      System.out.println("Error: gene_get: Wrong gene request. "+gene_no+" out of range.");
      return 0;
    }
  }

  //Speicher fuer Erweiterungen setzen
  public void gene_set(int gene_no, int gene_value) {
    if ((gene_no >= 0) && (gene_no < 16)) {
      this.genetable[gene_no] = gene_value;
    } else {
      System.out.println("Error: gene_set: Wrong gene set. "+gene_no+" out of range.");
    }
  }

}

