
#include "main.h"

uint8_t wheel_pos_r, wheel_pos_l; //gibt die Position der Rder an
//stellt ein, ob die Rder mit oder ohne Zwischenschritte drehen sollen
uint8_t wheel_eco;


void stepper_left_forward(void) {
  wheel_pos_l++;
  if (wheel_pos_l == 8) {
    wheel_pos_l = 0;
  }
}

void stepper_left_backward(void) {
  wheel_pos_l--;
  if (wheel_pos_l == 255) {
    wheel_pos_l = 7;
  }
}

void stepper_right_forward(void) {
  wheel_pos_r++;
  if (wheel_pos_r == 8) {
    wheel_pos_r = 0;
  }
}

void stepper_right_backward(void) {
  wheel_pos_r--;
  if (wheel_pos_r == 255) {
    wheel_pos_r = 7;
  }
}

const uint8_t stepper_data_array[] PROGMEM =
  {0x01,0x05,0x04,0x06,0x02,0x0a,0x08,0x09};

uint8_t stepper_data(uint8_t wheel_pos) {
if (wheel_eco != 0) {
  //setzt das hinterste Bit auf 0 um nur gerade Daten zu haben
  wheel_pos &= ~(1<<1);
}
return pgm_read_byte(&stepper_data_array[wheel_pos]);
}

void stepper_update(void) {
uint8_t outdata;
outdata = stepper_data(wheel_pos_r)<<4;
outdata |= stepper_data(wheel_pos_l);
PORTB = outdata;
}
