 /* Robo3 Steuerung mittels einer RC5 Fernbedienung
Autor: (c) 2005 by Malte Marwedel
Version: 1.00 erstellt: 2005-05-18
Verwendung: Verwendung auf eigene Verantwortung, ich bernehme keine Garantie
      dass diese Software fehlerfrei ist.
Verbreitung: Diese Software darf frei kopiert und compiliert werden.
      nderungen sind erlaubt solange kenntlich gemacht wird dass es sich
      nicht mehr um die original Datei handelt und weiterhin der Hinweis
      erhalten bleibt, dass von mir die Originalversion stammt.
RC5 Empfang: Der Urheber der Datei "rc5.c" bin NICHT ich (auch wenn die Datei
      von mir verndert wurde), sondern Peter Dannegger.
      Fr die Weiterverwendung gelten mglicherweise andere Bedingungen.
      Die Originalversion gibt es unter:
      http://www.mikrocontroller.net/forum/read-4-74473.html#74473
      Die Besttigung dass ich die Datei verwenden darf gibt es unter:
      http://www.mikrocontroller.net/forum/read-4-74473.html#168906
Compiler: Als Compiler habe ich avr-gcc Version 3.4.3 verwendet.
Libray: Als Libray kam avr-libc Version 1.2.3 zum Einsatz.
Code Gre: 1992Byte Flash.
Kontakt: www.marwedels.de/malte
      m.marwedel<AT>onlinehome.de
Hardware: AT90S2313 mit 4MHZ
      PORTD 0: Eingang, unbenutzt
      PORTD 1: Eingang, Infrarot Empfnger
      PORTD 2: Eingang, linker Taster
      PORTD 3: Eingang, rechter Taster
      PORTD 4: Ausgang, Status LED grn
      PORTD 5: Ausgang, Status LED rot
      PORTD 6: Eingang, unbenutzt
      PORTD 7: beim AT90S2313 nicht vorhanden
      PORTB 0: Ausgang, Stepper links, gelbe Leitung
      PORTB 1: Ausgang, Stepper links, orange Leitung
      PORTB 2: Ausgang, Stepper links, rote Leitung
      PORTB 3: Ausgang, Stepper links, braune Leitung
      PORTB 4: Ausgang, Stepper rechts, gelbe Leitung
      PORTB 5: Ausgang, Stepper rechts, orange Leitung
      PORTB 6: Ausgang, Stepper rechts, rote Leitung
      PORTB 7: Ausgang, Stepper rechts, braune Leitung
Fernbedienung: Die Bedienung des Roboters erfolgt ber eine gewhnliche Infrarot
      Fernbedienung, wie sie oft fr Fernseher, Videorecorder oder
      Stereoanlangen zu Einsatz kommt. ACHTUNG: Nicht alle Hersteller verwenden
      fr ihre Gerte die RC5 Kodierung - diese wird hier aber vorausgesetzt.
      Sollte ihre Fernbedienung zwar eine RC5 Kodierung verwenden die Belegung
      jedoch nicht passen, so lassen sich die Codes in der Datei main.h neu
      festlegen. Die Codes lassen sich relativ einfach mit dem Beispiel
      welches dem original Quelltext zur RC5 Decodierung von Peter Dannegger
      beiliegt selber ermitteln. Mit etwas Glck lassen sich zu ihrer
      Fernbedienung die zugerrigen Tastencodes auch direkt im Netz finden.
      Die Gerteadresse wird ignoriert.
Steuerung: In der Standardbelegung der der Tasten:
      Mit den Tasten 0-9 lsst sich die gewnschte Geschwindigkeit der
      Motoren auswhlen. Mit 4 Tasten lsst sich der Roboter
      in die jeweilige Richtung fahren/drehen. Bei meiner Belegung fhrt
      beispielsweise der Roboter mit "Lautstrke +" nach vorne und mit
      "Lautstrke -" rckwrts.
      Mit "Record" wird wird der Weg aufgezeichnet. Eine Strecke mit bis zu
      19 Fahrmanvern kann aufgezeichnet werden.
      "Stop" Stoppt die Aufzeichnung oder die Wiedergabe des Fahrmanvers
      "Play" lsst den Roboter die aufgezeichnete Strecke abfahren.
      Also so hnlich wie bei einem Videorecorder, nur dass anstelle von TV
      Programmen eben Fahrmanver aufgezeichnet werden und ein Zurckspulen
      automatisch bei jeder Wiedergabe oder Aufzeichnung erfolgt.
      "1. Sondertaste" Wird einer der Taster (die beiden vorne am Roboter)
      aktiviert, so fhrt der Roboter rckwrts, bis die Taster nicht mehr
      gedrckt werden.
      "2. Sondertaste" Wird eine Taste gedrckt, so setzt der Roboter kurz
      zurck, dreht sich und fhrt dann geradeaus weiter.
      "3. Sondertaste" Der Roboter fhrt gerade aus, bis er auf ein Hindernis
      stt - diesem versucht er dann zu folgen.
      Der Aufzeichnungsmodus kann nicht fehlerfrei mit den Farmanvern der 2.
      und 3. sondertaste kombiniert werden, da bei diesem beide Motoren mit
      unterschiedlicher Geschwindigkeit drehen aus Speicherplatzgrnden nur
      die Geschwindigkeit eines Motors aufgezeichnet wird.
LEDs: Die rote LED leuchtet immer und signalisiert somit Betriebsbereitschaft.
      Die grne LED geht beim Empfang eines RC5 Signals an und leuchtet so lange
      bis die Motoren zu Stillstand kommen.
*/


#include "main.h"

uint8_t wheel_max_l = 0; //maximale Geschwindigkeit linkes Rad (0..9)
uint8_t wheel_max_r = 0; //maximale Geschwindigkeit rechtes Rad (0..9)
uint8_t wheel_speed_l = 0; //die aktuelle Geschwindigkeit linkes Rad
uint8_t wheel_speed_r = 0; //die aktuelle Geschwindigkeit rechtes Rad
uint8_t wheel_direction_l = 0; //Gibt die Drehrichtung an (links)
uint8_t wheel_direction_r = 0; //Gibt die Drehrichtung an (rechts)

uint8_t wall_mode = 0; //0:nur kurz zurcksetzen, 1: umdrehen, 2:Wand folgen
uint8_t wall_act_state = 0; //derzeitige Position was die Reaktion angeht

//Timer Variablen
uint8_t volatile count_longperiod; //interne Variable zum 1/10s zu timen
uint8_t volatile count_motor_stop; //wenn  0, so werden die Motoren angeschaltet
uint8_t volatile count_gear; //langsamen hochschalten der Geschwindigkeit
uint8_t volatile count_wheel_l; //Counter bis zur nchsten Rad Position
uint8_t volatile count_wheel_r; //Counter bis zur nchsten Rad Position
uint16_t volatile count_recording; //wie lange eine Bewegung beibehalten wird
uint8_t volatile count_wall_act; //steuert die Drehdauer beim Wand vermeiden

SIGNAL (SIG_OVERFLOW1) {
//Soll jede Millisekunde berlaufen
TCNT1 = 61536; // 256-(4MHZ:1000)=61536
/*Sobald die Variablen Null erreichen, wird der nchste Schritt der Motoren
  ausgefhrt */
if (count_wheel_l) { //linker Motor
  count_wheel_l--;
}
if (count_wheel_r) { //rechter Motor
  count_wheel_r--;
}
//Counter fr lngere Zeiten (alle 1/10 sec)
count_longperiod--;
if (count_longperiod == 0) {
  count_longperiod = 100;
  //fr motor stoppen und aus
  if (count_motor_stop != 0) {
    count_motor_stop--;
  }
  if (count_gear < 9) {
    count_gear++;
  }
  if (count_recording != 0xffff) {
    count_recording++;
  }
  if (count_wall_act != 0xff) {
    count_wall_act++;
  }
}
}

uint8_t min(uint8_t a, uint8_t b) {
if (a < b) {
  return a;
}
return b;
}

void wall_reaction(void) {
uint8_t taster;

taster = PIND & 0x0c;
if (wall_mode == 0) { //bei Taster zurckfahren
  if (taster != 0) {
    wheel_direction_l = 2;
    wheel_direction_r = 2;
    wheel_max_l = 1;
    wheel_max_r = 1;
    if (recordingmode == 2)  {
      recordingmode = 0;
    }
  }
}
if (wall_mode == 1) { //Wnde vermeiden
  count_motor_stop = 5;
  if ((taster & 0x04) != 0) { //rechter Taster
    wall_act_state = 10;
    wheel_max_l = 4;
    wheel_max_r = 5;
    wheel_direction_l = 2;
    wheel_direction_r = 2;
    count_wall_act = 0;
  }
  if ((taster & 0x08) != 0) { //linker Taster
    wall_act_state = 20;
    wheel_max_l = 4;
    wheel_max_r = 5;
    wheel_direction_l = 2;
    wheel_direction_r = 2;
    count_wall_act = 0;
  }
  if (wall_act_state == 0 ) { //normales Fahren geradeaus
    wheel_max_l = 5;
    wheel_max_r = 5;
    wheel_direction_l = 1;
    wheel_direction_r = 1;
  }
  if (count_wall_act > 10) { //nach mehr als 1,0sec
    count_wall_act = 0;
    //fange wieder mit Fahren an
    if ((wall_act_state == 11)||(wall_act_state == 21)) {
      wall_act_state = 0;
    }
    if (wall_act_state == 10) { //beginne zu Drehen nach links
      wall_act_state++;
      wheel_direction_r = 1;
      wheel_max_r = 4;
    }
    if (wall_act_state == 20) { //beginne zu Drehen nach rechts
      wall_act_state++;
      wheel_direction_l = 1;
      wheel_max_l = 4;
    }
  }
} //ende Wand ausweichen
if (wall_mode == 2) { //Wnde folgen
  count_motor_stop = 5;
  if ((taster & 0x04) != 0) { //rechter Taster drehe nach links
    wall_act_state = 10;
    wheel_max_l = 5;
    wheel_max_r = 3;
    wheel_direction_l = 2;
    wheel_direction_r = 1;
    count_wall_act = 0;
    count_gear = 3;
  }
  if ((taster & 0x08) != 0) { //linker Taster
    wall_act_state = 20;
    wheel_max_l = 3;
    wheel_max_r = 5;
    wheel_direction_l = 1;
    wheel_direction_r = 2;
    count_wall_act = 0;
    count_gear = 3;
  }
  if (taster == 0) { //wenn kein Taster gedrckt
    wheel_direction_l = 1;
    wheel_direction_r = 1;
    if (wall_act_state == 0 ) { //normales Fahren geradeaus
      wheel_max_l = 5;
      wheel_max_r = 5;
      wall_act_state++;
      count_gear = 3;
    }
    if (wall_act_state == 10 ) { //Wand war rechts.. weiter nach rechts
      wheel_max_r = 2;
      wheel_max_l = 5;
      wall_act_state++;
      count_gear = 3;
    }
    if (wall_act_state == 20 ) { //Wand war links.. weiter nach links
      wheel_max_r = 5;
      wheel_max_l = 2;
      wall_act_state++;
      count_gear = 3;
    }
  } //ende wenn kein Taster gedrckt
}//ende Wand folgen
}



int main( void ) {
  uint16_t rc5_l; //RC5 Code
  uint8_t rc5_function;
  uint8_t rc5_toggle;

  //Initialisierung fr RC5 Routine
  TCCR0 = 1<<CS02;      //divide by 256
  TIMSK |= 1<<TOIE0;    //enable timer interrupt
  //Initialisierung fr Roboter I/O Ports
  DDRD = 0x30;          //Nur die Status LEDs als Ausgang
  DDRB = 0xff;          //Stepper Motoren
  //Timer 1 initialisieren
  TCNT1 = 0;            //setzt den Timer1 auf null (reset timer1)
  TCCR1B = 1;           //starte timer1, prescaler: 1, berlauft 1000x sec
  TIMSK |= 1<<TOIE1;    //enable timer2 interrupt
  sei();
  PORTD |= (1<<5);      //rote LED an
  for(;;){              //Hauptschleife
    cli();
    rc5_l = rc5_data;   //Zwei Byte vom Interrupt lesen
    rc5_data = 0;
    sei();
    if( rc5_l ){
      //Befehl extrahieren (die Gerte Adresse wird ignoriert)
      rc5_function = (rc5_l & 0x3F) | (~rc5_l >> 7 & 0x40);
      rc5_toggle = rc5_l >> 6 & 0x1F;
      PORTD |= (1<<4); //grne LED an
      //Direkte Bewegung der Motoren
      if (rc5_function == drive_forward) { //nach vorne
        count_motor_stop = 6;
        wheel_direction_l = 1;
        wheel_direction_r = 1;
      }
      if (rc5_function == drive_backward) { //nach hinten
        count_motor_stop = 6;
        wheel_direction_l = 2;
        wheel_direction_r = 2;
      }
      if (rc5_function == drive_right) { //nach rechts
        count_motor_stop = 6;
        wheel_direction_l = 1;
        wheel_direction_r = 2;
      }
      if (rc5_function == drive_left) { //nach links
        count_motor_stop = 6;
        wheel_direction_l = 2;
        wheel_direction_r = 1;
      }
      //Gnge fr Geschwindigkeit
      if (rc5_function < 10)  {
        wheel_max_l = rc5_function;
        wheel_max_r = wheel_max_l;
      }
      //recording Modus
      if (rc5_function == recmode_record) { //record
        recordingmode = 1;
        recordingindex = 0;
        cli();
        count_recording = 0;
        sei();
      }
      if (rc5_function == recmode_play) { //play
        recordingmode = 2;
        recordingindex = 0;
        cli();
        count_recording = 0;
        sei();
      }
      if (rc5_function == recmode_stop) { //stop
        record_stop();
      }
      //Wall ausweich Programm
      if (rc5_function == wall_driveback) { //nur rckwrts fahren
        wall_mode = 0;
      }
      //umdrehen und in eine andere Richtung fahren
      if (rc5_function == wall_driveaway) {
        wall_mode = 1;
        wall_act_state = 0;
      }
      if (rc5_function == wall_follow) { //der Wand folgen
        wall_mode = 2;
        wall_act_state = 0;
      }
    }
    record_control();
    wall_reaction();
    calculatewheels();
    speedcontrol();
  }
}

void speedcontrol(void) {
wheel_speed_l = min(wheel_max_l,count_gear);
wheel_speed_r = min(wheel_max_r,count_gear);
}

//die Formel ist ungefhr 0.36x-6,76x+34,57
//Dabei msste jeder niedriger Gang 1/3 langsamer sein als der vorherige
const uint8_t delay_gear_table[10] = {40,30,22,17,13,9,7,5,4,3};

void calculatewheels(void) {
//Stoppen wenn kein RC5 Signal anliegt
if (count_motor_stop < 4) { //langsamer werden (rund 300ms brig)
  count_gear = min(min((wheel_max_l/2)+1,(wheel_max_r/2)+1), count_gear);
}
if (count_motor_stop < 3) { //rund 200ms bis zum Abschalten
  stepper_eco_on();
  wheel_direction_l = 0;
  wheel_direction_r = 0;
} else {
  stepper_eco_off();
}
//nchste Position von wheel_pos berechnen
if (count_wheel_l == 0) { //links
  count_wheel_l = delay_gear_table[wheel_speed_l];
  if (wheel_direction_l == 1) { //vorwrts
    stepper_left_forward();
  }
  if (wheel_direction_l == 2) { //rckwrts
    stepper_left_backward();
  }
}
if (count_wheel_r == 0) { //rechts
  count_wheel_r =  delay_gear_table[wheel_speed_r];
  if (wheel_direction_r == 1) { //vorwrts
    stepper_right_forward();
  }
  if (wheel_direction_r == 2) { //rckwrts
    stepper_right_backward();
  }
}
//Rder abschalten zum Stromsparen nach 255ms seit des letzten IR Signals.
if (count_motor_stop == 0) {
  stepper_idle();
  PORTD &= ~(1<<4); //grne LED aus
  count_gear = 0;
} else {
  stepper_update();
}
}

