#include "main.h"

struct dataset motorrecord[recordingsize];
uint8_t recordingmode; //0= off, 1= record, 2 = play
uint8_t recordingindex;


void record_stop(void) {
if (recordingmode == 1) {
  motorrecord[recordingindex].duration = 0xffff;
}
recordingmode = 0;
}

void record_control(void)  {
//unteren 4 bit = Geschwindigkeit
//Bit 5+6 = linker Motor
//Bit 7+8 = rechter Motor
uint8_t current_dir_gear;
uint16_t count_recording_local;

if (recordingmode == 1) { //record
  current_dir_gear = wheel_max_l +(wheel_direction_l<<4)+(wheel_direction_r<<6);
  //neuer Datensatz
  if (motorrecord[recordingindex].dir_gear != current_dir_gear) {
    cli();
    motorrecord[recordingindex].duration = count_recording;
    count_recording = 0;
    sei();
    recordingindex++;
    if (recordingindex == recordingsize) { //Speicher voll
      recordingmode = 0;
      recordingindex--;
    } else { //neue Motordaten aufzeichnen
      motorrecord[recordingindex].dir_gear = current_dir_gear;
    }
  }
}
if (recordingmode == 2)  { //play
  current_dir_gear = motorrecord[recordingindex].dir_gear;
  if ((current_dir_gear & 0xf0) != 0) { //wenn Motoren drehen
    count_motor_stop = 6;
  }
  wheel_max_l = current_dir_gear & 0x0f;
  wheel_max_r = wheel_max_l;
  wheel_direction_l = (current_dir_gear>>4)&0x03;
  wheel_direction_r = (current_dir_gear>>6)&0x03;
  cli(); //da 16bit Variable
  count_recording_local = count_recording;
  sei();
  if (motorrecord[recordingindex].duration <= count_recording_local) {
    cli();
    count_recording = 0;
    sei();
    if (recordingmode == 2) { //Abspielen
      recordingindex++;
      if (recordingindex == recordingsize) { //ende der Aufzeichnung
        recordingmode = 0;
        recordingindex--;
      }
    }
  } //ende neuen Datensatz abspielen
  if (motorrecord[recordingindex].duration == 0xffff) { //ende der Aufzeichnung
    recordingmode = 0;
    wheel_direction_l = 0;
    wheel_direction_r = 0;
  }
} //ende Datensatz abspielen
}
