
#ifndef STATESTORAGE_H
#define STATESTORAGE_H

#include <inttypes.h>

//must be equal or greater than MAXURLLEN
#define STATE_MAX_PATHLEN 500

//artist name for lastfm station
#define STATE_MAX_STATIONLEN 128

#define EEPROM_SETTINGS 128
#define EEPROM_PLAYINGS (EEPROM_SETTINGS + sizeof(permanent_settings_t))
#define EEPROM_STATS (EEPROM_PLAYINGS + sizeof(streamstate_nonvolatile_t))
#define EEPROM_LASTFM (EEPROM_STATS + sizeof(permastats_t))
#define EEPROM_LASTSTATION (EEPROM_LASTFM + sizeof(lastfm_auth_t))
#define EEPROM_SOURCENAME (EEPROM_LASTSTATION + STATE_MAX_STATIONLEN)

#define STREAM_VOLUME_MAX 31

#define EVENT_LEAVELEARN 101
#define EVENT_REDRAW 129
#define EVENT_ALLINIT 100
#define EVENT_CLOSE_SELECT 102
#define EVENT_SHOW_FILEPLAYER 103
#define EVENT_SHOW_NETWORKPLAYER 104
#define EVENT_SHOWERROR 130
#define EVENT_SHOWINFO 131

#define INIT_STEPS 9

#define INIT_NET_DONE 0
#define INIT_NETCONFIG_DONE 1
#define INIT_MP3_DONE 2
#define INIT_FS_DONE 3
#define INIT_BLKDEV_DONE 4
#define INIT_MOUNT_DONE 5
#define INIT_FTPROOT_DONE 6
#define INIT_FTP_DONE 7
#define INIT_CLOCK_DONE 8

#define RC5REPEATS_PRESS 5
#define REMOTECODES 21

//mp3_status, possible states
#define STREAM_STOPPED 0
#define STREAM_PLAY_FILE_START 1
#define STREAM_PLAY_NETWORK_START 2
#define STREAM_PLAY_FILE 3
#define STREAM_PLAY_NETWORK 4
#define STREAM_FILE_END 5
#define STREAM_NETWORK_BUFFER_EMPTY 6
#define STREAM_STOP 7
#define STREAM_PLAY_LASTFM_START 8
#define STREAM_PLAY_LASTFM_NEXT 9
#define STREAM_PLAY_LASTFM 10

#define STREAM_INVALID 255


//mp3_soure type
#define STREAM_TYPE_UNDEFINED 0
#define STREAM_TYPE_FILE 1
#define STREAM_TYPE_NETWORK 2


/*
recording states:
Recording only starts if there are at least 4MB free space

0: stop
1: record until title end
2: record until user abort

old request y, new request x
y  x
0, 0 = no changes
0, 1 = open new file
0, 2 = open new file
1, 1 = close file, open new file
1, 2 = change to state 2
1, 0 = close file
2, 0 = close file
2, 1 = no changes
2, 2 = no changes
*/

//min free space in KB
#define STREAM_RECORDING_MINMEMSTARTFREE 5000L
#define STREAM_RECORDING_MINMEMFREE 1000L


#define STREAM_RECORDING_STOP 0
#define STREAM_RECORDING_TITLE 1
#define STREAM_RECORDING_CONTINUOUS 2
#define STREAM_RECORDING_UNCHANGED 3

typedef struct {
uint8_t nextstate;
uint8_t laststate; //only needed for the state save and recording function
uint8_t recording;
uint8_t recordingnext;
char * source; //stream or filename
uint8_t sourcetype; // 1 = file, 2 = network
uint16_t sourcefd;
uint16_t targetfd; //target for stream recording
uint32_t length;
uint32_t played;
uint16_t bits;
uint8_t volume;
unsigned char * metasource;
unsigned char * metaalbum;
char * radioname; //only important for lastfm
} streamstate_t;

typedef struct {
uint8_t sourcetype;
uint8_t laststate;
uint8_t volume;
uint8_t recordandplaymode; //upper 4 bit: recording mode, lower 4 bit: playmode
uint16_t sourcelength;
} streamstate_nonvolatile_t;

extern streamstate_t stream_state;

extern uint8_t state_player_stopped; //1 if shut down

typedef struct {
uint32_t mp3totaltraffic; //traffic in MB since ever -> max: ~500000 years
uint32_t reboots;
uint32_t operatingminutes; //in minutes -> max: 8172 years
uint32_t checksum; //xor the three values above + 42
} permastats_t;

void state_init(void);
void state_error(uint8_t errornum);
void state_save_settings(void);

void state_save_playingstate(void);
uint8_t state_load_playingstate(void);

uint32_t state_totaltraffic_get(void);
uint32_t state_reboots_get(void);
uint32_t state_operatingminutes_get(void);
void state_save_stats(void);

uint32_t state_ip_get(void);
void state_ip_set(uint32_t ip);

uint32_t state_gateway_get(void);
void state_gateway_set(uint32_t gw);

uint32_t state_dns_get(void);
void state_dns_set(uint32_t dns);

void state_bassboost_update(void);
void state_bassboost_set(uint8_t value);

uint8_t state_autorestore_get(void);
void state_autorestore_set(uint8_t value);

void state_pause_toggle(void);
void state_pause_off(void);

uint8_t state_fileselectmode_get(void);
void state_fileselectmode_set(uint8_t mode);

void state_sortfilenames_set(uint8_t value);
uint8_t state_sortfilenames_get(void);

uint8_t state_event_get(void);
uint8_t state_event_peek(void);
void state_event_put(uint8_t event);

void state_devinit_set(uint8_t device);
uint8_t state_devinit_get(uint8_t device);

void state_backlight_dec(void);
void state_backlight_inc(void);
uint8_t state_backlight_get(void);

void state_mp3_volume_update(void);
void state_mp3_volume_dec(void);
void state_mp3_volume_inc(void);
uint8_t state_mp3_volume_get(void);

void state_mp3_fileplay(char * filename);
void state_mp3_urlplay(char * filename);
void state_mp3_replay(void);
void state_mp3_stop(void);
void state_mp3_lastfmskip(void);

void state_mp3_seclen(uint16_t seconds);
uint16_t state_mp3_seclen_get(void);
void state_mp3_secplayed(uint16_t seconds);
void state_mp3_playtimetoggle(void);
void state_mp3_secupdate(void);

void state_bufffill_set(uint8_t percent);

void state_mp3_filename(char * filename);

void state_id3_set(char * text, uint8_t type);
void state_id3_clear(void);
void state_filenameonemptytitle(void);
char * state_id3_get(uint8_t type);

void state_rc5_rec(uint16_t data);
void state_rc5_learn_start(uint8_t idx);
void state_rc5_learn_stop(void);
uint16_t state_rc5_code_get(uint8_t idx);

uint8_t state_usedhcp(void);
void state_dhcpset(uint8_t value);

void state_stats_traffic_add(uint16_t value);
uint32_t state_stats_traffic_get(void);

void state_record_change(uint8_t newstate);
void state_record_trychange(uint8_t newstate);

uint8_t state_recordmode_get(void);

void state_recordmode_set(uint8_t mode);

char * state_lastfm_md5pwd_get(void);
char * state_lastfm_username_get(void);
uint8_t state_lastfm_recordallow_get(void);
uint8_t state_lastfm_validconfig_get(void);
void state_lastfm_config_set(uint8_t valid, uint8_t recordallow, char * username, char * md5pwd);
char * state_lastfm_stationname_get(void);

#endif
