/* Infplay
  (c) 2009-2010 by Malte Marwedel
  www.marwedels.de/malte

  This file is based on example source code from Nut/OS.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <compiler.h>
#include <fs/phatvol.h>

#include "hardware/vs1002drv.h"
#include "infplay.h"
#include "statestorage.h"
#include "streamlogic.h"
#include "recorder.h"

static prog_char sfsreg[] = "FS registered";
static prog_char sfsregerr[] = "FS registered failed";
static prog_char sbkreg[] = "BK dev registered";
static prog_char sbkregerr[]= "BK dev registered failed";
static prog_char smount[] = "Partition mounted";
static prog_char smounterr[] = "Partition mount failed";
static prog_char ftproot[] = "FTP Root registered";
static prog_char ftprooterr[] = "FTP Root failed";

//gets the free space in KB
uint32_t spi_mmc_kbfree(void) {
	PHATVOL *vol = (PHATVOL *) ((&FSDEV)->dev_dcb);
	uint64_t fsfree = 0;
	if (vol) {
		uint64_t fssize = vol->vol_clustsz*vol->vol_sectsz;
		fsfree = vol->vol_numfree;
		fsfree *= fssize;
		fsfree /= 1000;
	}
	return (uint32_t)fsfree;
}

//defined in dev/mmcard.c
extern HANDLE myspimutex;

int mmc_volid = -1;

THREAD(SpiInit, arg) {
	NutEventPost(&myspimutex); //acts as mutex init.
	if (!mp3dev_init()) {
		state_devinit_set(INIT_MP3_DONE);
		state_mp3_volume_update();
		puts_P(PSTR("mp3 decoder init"));
	} else
		puts_P(PSTR("mp3 decoder init failed"));
#ifdef FSDEV
	/* Initialize the file system. */
	if (!NutRegisterDevice(&FSDEV, 0, 0)) {
 		state_devinit_set(INIT_FS_DONE);
		puts_P(sfsreg);
#ifdef BLKDEV
	/* Register block device. This is the SPI + MMC init.*/
		if (!NutRegisterDevice(&BLKDEV, 0, 0)) {
			state_devinit_set(INIT_BLKDEV_DONE);
			puts_P(sbkreg);
			/* Mount partition. */
			if ((mmc_volid = _open(BLKDEV_NAME ":1/" FSDEV_NAME, _O_RDWR | _O_BINARY)) >= 0) {
				state_devinit_set(INIT_MOUNT_DONE);
				puts_P(smount);
				/* Register ftp root */
				if (!NutRegisterFtpRoot(FSDEV_NAME ":")) {
					state_devinit_set(INIT_FTPROOT_DONE);
					puts_P(ftproot);
				} else
					puts_P(ftprooterr);
			} else
				puts_P(smounterr);
		} else
			puts_P(sbkregerr);
#endif
	} else
		puts_P(sfsregerr);
#else
    mmc_volid = 0;
#endif
	NutThreadSetPriority(60);
	state_bufffill_set(0);
	if (state_autorestore_get()) {
		state_load_playingstate();
	}
	recorder_init(); //not in infplay.c because it needs the mounted filesystem
	while(1) {
		stream_handle();
		NutSleep(50);
	}
}
