#ifndef NET_NUTTOUNIX_H
#define NET_NUTTOUNIX_H

#include <stdio.h>
#include <stdint.h>

#ifndef CONST
#define CONST const
#endif

#ifdef TEST_PC
#define NUTDEVICE int
#endif


#define TCPSOCKET int


//defines copied from Nut/OS header tcp_fsm.h
#ifndef TCP_NODELAY
#define TCP_NODELAY 0x01
#endif

#ifndef TCP_MAXSEG
#define TCP_MAXSEG  0x02
#endif

#ifndef TC_NOPUSH
#define TCP_NOPUSH  0x04
#endif

#ifndef TCP_NOOPT
#define TCP_NOOPT   0x08
#endif

#define TCPS_CLOSED         0
#define TCPS_LISTEN         1
#define TCPS_SYN_SENT       2
#define TCPS_SYN_RECEIVED   3
#define TCPS_ESTABLISHED    4
#define TCPS_CLOSE_WAIT     5
#define TCPS_FIN_WAIT_1     6
#define TCPS_CLOSING        7
#define TCPS_LAST_ACK       8
#define TCPS_FIN_WAIT_2     9
#define TCPS_TIME_WAIT      10

#define DEV_ETHER_NAME "ethnull"
extern NUTDEVICE DEV_ETHER;

extern long _timezone;

char* compat_inet_ntoa(uint32_t addr);

uint32_t NutDnsGetHostByName(unsigned char * domain);
TCPSOCKET * NutTcpCreateSocket(void);
int NutTcpConnect(TCPSOCKET *sock, uint32_t addr, uint16_t port);
int NutTcpCloseSocket (TCPSOCKET *sock);
int NutTcpSetSockOpt(TCPSOCKET *sock, int optname, void *optval, int optlen);
int NutNetIfConfig2(CONST char *name, void *params, uint32_t ip_addr, uint32_t ip_mask, uint32_t gateway);
int NutDhcpIfConfig(CONST char * name, uint8_t * mac, uint32_t timeout);
void NutDnsConfig2(uint8_t *hostname, uint8_t *domain, uint32_t pdnsip, uint32_t sdnsip);
NUTDEVICE* NutIpRouteQuery(uint32_t ip, uint32_t * gate);
void NutDnsGetConfig2(char **hostname, char **domain, uint32_t *pdnsip, uint32_t *sdnsip);
int NutSNTPGetTime(uint32_t *server_adr, time_t *t);

#ifdef TEST_PC
FILE * net_connectandopen(TCPSOCKET ** sock, uint32_t ip, uint16_t port);
#endif

#endif
