/* Infplay
  (c) 2009-2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef __NUT_EMULATION__
#include <compiler.h>
#include <sys/confnet.h>

CONFNET confnet;

#else

#include "avrmapper.h"

#endif

#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>
#include <netdb.h>
#include <string.h>

#include "net_nuttounix.h"


uint32_t NutDnsGetHostByName(unsigned char * domain) {
	//resolve domain to an ip
	struct hostent * h = gethostbyname((char *)domain);
	if ((h == NULL) || (!(h->h_addr_list[0]))) {
		printf("Resolving host failed\n");
		return 0;
	}
	int a = (unsigned char)(h->h_addr_list[0][0]);
	int b = (unsigned char)(h->h_addr_list[0][1]);
	int c = (unsigned char)(h->h_addr_list[0][2]);
	int d = (unsigned char)(h->h_addr_list[0][3]);
	uint32_t ip = (a<<24)+(b<<16)+(c<<8)+d;
	return htonl(ip);
}

int NutTcpConnect(TCPSOCKET *sock, uint32_t addr, uint16_t port) {
	struct sockaddr_in echoServAddr;
	if ((*sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
		return -1;
	}
	memset(&echoServAddr, 0, sizeof(echoServAddr));
	echoServAddr.sin_family = AF_INET;
	echoServAddr.sin_addr.s_addr = addr;
	echoServAddr.sin_port = htons(port);
	if (connect(*sock, (struct sockaddr *) &echoServAddr, sizeof(echoServAddr)) < 0) {
		printf("NutTcpConnect failed\n");
		return -1;
	}
	fcntl(*sock, F_SETFL, O_NONBLOCK); //for testing error recovery
	return 0;
}

TCPSOCKET * NutTcpCreateSocket(void) {
	return malloc(sizeof(TCPSOCKET));
}

int NutTcpCloseSocket(TCPSOCKET *sock) {
	free(sock);
	return 0;
}

int NutTcpSetSockOpt(TCPSOCKET *sock, int optname, void *optval, int optlen) {
	if (optname == TCP_MAXSEG) {
		return 0;
	}
	if (optname == TCP_NODELAY) {
		return 0;
	}
	if (optname == TCP_NOPUSH) {
		return 0;
	}
	if (optname == TCP_NOOPT) {
		return 0;
	}
	return -1;
}

int NutDhcpIfConfig(CONST char * name, uint8_t * mac, uint32_t timeout) {
	return 0; //always success
}

void NutDnsConfig2(uint8_t *hostname, uint8_t *domain, uint32_t pdnsip, uint32_t sdnsip) {
}

void NutDnsGetConfig2(char **hostname, char **domain, uint32_t *pdnsip, uint32_t *sdnsip) {
	if (pdnsip != NULL) {
		*pdnsip = 0x0100007F; //is wrong, but better than nothing
	}
}

int NutSNTPGetTime(uint32_t *server_adr, time_t *t) {
	return 0;
}

char * compat_inet_ntoa(uint32_t ip) {
	static char ipaddr[16];
	sprintf(ipaddr, "%u.%u.%u.%u", ip%256, (ip>>8)%256, (ip>>16)%256, ip>>24);
	ipaddr[15] = '\0';
	return ipaddr;
}

#ifdef TEST_PC

//Same function as in network.c

FILE * net_connectandopen(TCPSOCKET ** sock, uint32_t ip, uint16_t port) {
	*sock = NutTcpCreateSocket();
	if (*sock == NULL) {
		puts("socket create failed");
		return NULL;
	}
	if (NutTcpConnect(*sock, ip, port)) {
		puts("NutTcpConnect failed");
		return NULL;
	}
	//open stream
	FILE * stream;
	if ((stream = _fdopen((int)*sock, "r+b")) == 0) {
		puts("_fdopen failed");
		NutTcpCloseSocket(*sock);
		return NULL;
	}
	return stream;
}

#else

int NutNetIfConfig2(CONST char *name, void *params, uint32_t ip_addr, uint32_t ip_mask, uint32_t gateway) {
	confnet.cdn_ip_addr = ip_addr;
	confnet.cdn_gateway = gateway;
	return 0; //always success
}

NUTDEVICE* NutIpRouteQuery(uint32_t ip, uint32_t * gate) {
	if (gate != NULL) {
		*gate = confnet.cdn_gateway;
	}
	return NULL;
}

#endif
