/* Infplay
  (c) 2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

void * s_cmalloc(size_t size) {
	void * buff = calloc(size, 1);
	if (buff == NULL) {
		printf("Out of memory\n");
		exit(1);
	}
	return buff;
}

void error_general(uint8_t errornum) {
	printf("E:%i\n", errornum);
}

void error_message_P(char * pgmtext) {
	printf("Error message: %s\n", pgmtext);
}

void info_message_P(char * pgmtext) {
	printf("Info message: %s\n", pgmtext);
}

void ThreadTerminate(void) {
	puts("ThreadTerminate() called");
	exit(1);
}

uint32_t NutGetSeconds(void) {
	time_t t;
	time(&t);
	return t;
}

uint32_t pgm_read_dword(uint32_t * value) {
	return *value;
}

FILE * _fdopen(int fd, const char *mode) {
	return fdopen(*(int *)fd, mode);
}
