/* Infplay
  (c) 2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <compiler.h>
#include <sys/thread.h>
#include <unistd.h>
#include <sys/timer.h>
#include <time.h>
#include <sys/time.h>
#include "thread/userthread.h"

NUTTHREADINFO *runningThread;
NUTTHREADINFO *nutThreadList;
NUTTHREADINFO *runQueue;

HANDLE NutThreadCreate(char *name, void (*fn) (void *), void *arg, size_t stackSize) {
	userthread_spawn(fn);
	return NULL;
}

uint32_t getMilis(void) {
	struct timeval data1;
	gettimeofday (&data1, NULL);
	return data1.tv_sec*1000+data1.tv_usec/1000;
}

void NutSleep(uint32_t ms) {
	uint32_t entermil = getMilis();
	while ((entermil + ms > getMilis()) && (entermil < getMilis())) {
		usleep(1000); //prevents unneccessary high cpu load
		userthread_yield();
	}
}

void NutThreadRemoveQueue(NUTTHREADINFO * td, NUTTHREADINFO * volatile *tqpp) {
}

void NutThreadYield(void) {
	userthread_yield();
}

uint8_t NutThreadSetPriority(uint8_t level) {
	return 65;
}
