
#ifndef USERTHREADEAD_H
  #define  USERTHREADEAD_H

#include <ucontext.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/poll.h>
#include <sys/select.h>
#include "lists.h"

/* stack sizes for thread */
#define USER_STACK_SIZE 10000
#define STACK_SIZE (USER_STACK_SIZE + MINSIGSTKSZ)

//defines for process status
#define USERTHREAD_RUNNABLE 1
#define USERTHREAD_ZOMBIE_WITH_STACK 4
#define USERTHREAD_ZOMBIE_WITHOUT_STACK 5

//Struct for a thread context

struct proc_state {
   struct list_manage head;
   ucontext_t ucp;
   int pid;
   int status;
};

/* process type function */
typedef void (*userthread_proc_func)();

/* creates a new process */
extern int userthread_spawn(userthread_proc_func f);

/* next process */
extern void userthread_yield();

/* init the lib */
extern void userthread_init(userthread_proc_func f);

#endif
