/*
Cooperative Thread Libray
(c) 2006-2007 by Malte Marwedel
(c) 2010 redux version without unnecessary features

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "userthread.h"
#include <unistd.h>
#include <stdlib.h>
#include <ucontext.h>

//always shows a used! pidcount
unsigned int volatile pidcount;

struct list_manage volatile queue_run;
struct list_manage volatile queue_terminated;

struct proc_state volatile * current_process;

/* creates a memory region for the stack of the thread */
static void userthread_make_stack(stack_t *stk) {
  stk->ss_sp = malloc(STACK_SIZE);
  if (stk->ss_sp == NULL) {
    printf("userthread_make_stack: Error: Out of memory! Exiting.\n");
    exit(1);
  }
  stk->ss_flags = 0;
  stk->ss_size = STACK_SIZE;
}

/* Returns a pid, which is unused, terminates the program if we get out
   of pids */
static int userthread_getfreepid() {
pidcount++;
if (pidcount == 0) {
  printf("userthread_getfreepid: Error: Out of pids! Exiting\n");
  exit(1);
}
return pidcount;
}

/* Add a process */
int userthread_spawn(userthread_proc_func f) {
struct proc_state * newproc_table = malloc(sizeof(struct proc_state));	//list element in queue
if (newproc_table == NULL) {
  printf("userthread_spawn: Error: Out of memory! Exiting.\n");
  exit(1);
}
//generate context for function
getcontext(&(newproc_table->ucp));
userthread_make_stack(&(newproc_table->ucp.uc_stack));		//make stack
makecontext(&(newproc_table->ucp) ,f , 0);
//construct
newproc_table->status = USERTHREAD_RUNNABLE;
newproc_table->pid = userthread_getfreepid();
//put function in runqueue
list_add_tail((struct list_manage*)newproc_table,(struct list_manage*)&queue_run);
//return PID of child process
return pidcount;
}

/* wakes up next process*/
void userthread_yield_nextone() {
/*
   If a runnable task is found, he will be removed from the list and put on the
     CPU.
   While going through the list we count how many tasks are waiting for IO.

   A empty list will result in a program termination.
*/
//as long as there is at least one process in the runqueue
while ((struct list_manage*)&queue_run != (struct list_manage*)(queue_run.next)) {
  //search for a runnable process
  struct proc_state* s_proc = (struct proc_state*)queue_run.next;
  while ((struct list_manage*)s_proc != (struct list_manage*)&queue_run) {
    if (s_proc->status == USERTHREAD_RUNNABLE) {
      //We found a runnable process
      struct proc_state * old_process = (struct proc_state*)current_process;
      current_process = (struct proc_state*)list_del((struct list_manage*)(s_proc));
      if (old_process->pid != current_process->pid) {
        //Swap only if the processes are different
        swapcontext(&(old_process->ucp), (ucontext_t*)&(current_process->ucp));
      }
      return;
    }
    s_proc = (struct proc_state*)s_proc->head.next;
  }
}
printf("userthread_yield_nextone: Error: All processes are terminated or waiting on each other\n");
exit(0);
}

/* switches to the next process */
void userthread_yield() {
//add current process to runlist -> list can not be empty anylonger
list_add_tail((struct list_manage*)current_process, (struct list_manage*)&queue_run);
userthread_yield_nextone(); //determine which task is next
}

/* inits the threading lib */
void userthread_init(userthread_proc_func f) {
//init the lists
list_init((struct list_manage*)&queue_run);
list_init((struct list_manage*)&queue_terminated);
userthread_spawn(f);
current_process = (struct proc_state*)list_del((struct list_manage*)queue_run.next);		//loads the pid and removes from list
setcontext((ucontext_t*)&(current_process->ucp));
}
