/* double concaternated list manager
  (c) 2006 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "lists.h"

void list_init(struct list_manage *head) {
head->next = head;
head->prev = head;
}

void list_add(struct list_manage *newe, struct list_manage *head) {
//Insert AFTER head
newe->prev = head;
newe->next = head->next;
head->next = newe;
newe->next->prev = newe;
}

void list_add_tail(struct list_manage *newe, struct list_manage *head) {
//Insert BEFORE head
newe->prev = head->prev;
newe->next = head;
head->prev->next = newe;
head->prev = newe;
}

struct list_manage* list_del(struct list_manage *entry) {
if (list_empty(entry) == 0) {
  entry->prev->next = entry->next;
  entry->next->prev = entry->prev;
  entry->next = 0;
  entry->prev = 0;
} else
  printf("list_del: Error: Tried to remove from empty list\n");
return entry;
}

void list_move(struct list_manage *entry, struct list_manage *head) {
list_del(entry);
list_add(entry, head);
}

void list_move_tail(struct list_manage *entry, struct list_manage *head) {
list_del(entry);
list_add_tail(entry, head);
}

int list_empty(struct list_manage *head) {
//Returns: 1 if empty; 0 if not empty
if ((head->next == head) && (head->prev == head)) {
  return 1;    //List is empty
}
return 0;
}
