#!/bin/bash

which mpg123

if [ $? -ne 0 ] ; then

echo "mpg123 not found. The PC build needs this program to play."
echo "You should try installing it from your repository (on Ubuntu/Debian: apt-get install mpg123)."

exit 1

fi

echo "Keyboard controls: w: up, s: down, a: back, d: enter, e: skip track, q: quit"

sleep 2

mkfifo mp3pipe

#see debian bug report: http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=561857
export LD_LIBRARY_PATH=/usr/lib/mpg123

mpg123 mp3pipe >/dev/null 2>mpg123error.log &

MPGPID=$!

which ./infplay-ncurses

if [ $? -eq 0 ] ; then

./infplay-ncurses mp3pipe ..
RET=$?

else

./infplay mp3pipe ..
RET=$?

fi

if [ $RET  -eq 141 ] ; then

echo "Program was killed, because the reading side of the pipe has been closed"

fi

kill $MPGPID

rm mp3pipe
