/* Infplay
  (c) 2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#define _GNU_SOURCE
#include <compiler.h>
#include <unistd.h>
#include <sys/timer.h>
#include <sys/heap.h>
#include <sys/confnet.h>
#include <poll.h>
#include <fcntl.h>
#include "../bigbuff.h"
#include "../statestorage.h"
#include "../filemanager.h"
#include "thread/userthread.h"


#ifdef USECURSES
#include <ncurses.h>
#endif

NUTDEVICE DEV_DEBUG;
NUTDEVICE DEV_BLK;
NUTDEVICE DEV_FS;
NUTDEVICE DEV_ETHER;

uint8_t volatile SREG;
uint8_t volatile MCUCSR = 1; //power on reset flag
uint8_t volatile PORTE;
uint8_t volatile UBRR0H;
uint8_t volatile UBRR0L;
uint8_t volatile UCSR0A;
uint8_t volatile UCSR0B;
uint8_t volatile UDR0;

long _timezone;

uint32_t NUTBANK_START;

uint8_t * ARTHERCPLDSTART;

FILE * messagefile;

FILE * mp3pipe;

PHATVOL * playervol;

time_t starttime;

char * initialdir;
char * basedir;

CONST char *NutVersionString(void) {
	return "0.0.0.0";
}

HANDLE myspimutex;

HEAPNODE * heapFreeList;

int NutRegisterDevice(NUTDEVICE *dev, uintptr_t base, uint8_t irq) {
	return 0; //means success
}

int _open(CONST char *name, int mode) {
	return 0;
}

int _close(int fd) {
	return 0;
}

int _ioctl(int fd, int cmd, void * data) {
	return 0;
}

int _fileno(FILE * stream) {
	return 0;
}

FILE * _fdopen(int fd, const char *mode) {
	int realfd = *(int *)fd;
	int flags = fcntl(realfd, F_GETFL, 0);
	flags |= O_NONBLOCK; //make nonblocking
	fcntl(realfd, F_SETFL, &flags);
	return fdopen(*(int *)fd, mode);
}

void wdt_reset(void) {
}

void wdt_enable(int delay) {
}

int NutEventPost(volatile HANDLE * qhp) {
	return 0;
}

int NutRegisterFtpRoot(CONST char * path) {
	return 0;
}

size_t NutHeapRootAvailable(HEAPNODE** root) {
	return 20000;
}

uint32_t NutGetSeconds(void) {
	time_t t;
	time(&t);
	return t-starttime;
}

uint32_t NutGetTickCount(void) {
	return NutGetSeconds();
}

void _delay_ms(double v) {
	usleep((uint32_t)(v*1000));
}

void Spi_writeclear(void) {
}

uint8_t Spi_haswritten(void) {
	return 0;
}

void rotencoderInit(void) {
}

void rc5Init(void) {
}

uint32_t pgm_read_dword(void * value) {
	return *(uint32_t *)value;
}

uint8_t pgm_read_byte(void * value) {
	return *(uint8_t *)value;
}

#define EEPROMSIZE 4096

int NutNvMemLoad(unsigned int addr, void *buff, size_t siz) {
	if (addr+siz > EEPROMSIZE) {
		return -1;
	}
	chdir(initialdir);
	FILE * f = fopen("virtualeeprom", "r+b");
	chdir(basedir);
	if (f == NULL) {
		return -1;
	}
	uint8_t eep[EEPROMSIZE];
	int i;
	for (i = 0; i < EEPROMSIZE; i++) {
		eep[i] = 0;
	}
	fread(eep, 1, EEPROMSIZE, f);
	memcpy(buff, eep+addr, siz);
	fclose(f);
	return 0;
}

int NutNvMemSave(unsigned int addr, CONST void *buff, size_t len) {
	if (addr+len > EEPROMSIZE) {
		return -1;
	}
	uint8_t eep[EEPROMSIZE];
	int i;
	for (i = 0; i < EEPROMSIZE; i++) {
		eep[i] = 0;
	}
	NutNvMemLoad(0, eep, EEPROMSIZE);
	memcpy(eep+addr, buff, len);
	printf("Write: %i %i\n", addr, len);
	chdir(initialdir);
	FILE * f = fopen("virtualeeprom", "w+b");
	chdir(basedir);
	if (f == NULL) {
		return -1;
	}
	fwrite(eep, 1, EEPROMSIZE, f);
	fclose(f);
	return 0;
}

void FtpService(void) {
	NutSleep(1000);
}

void backlight_set(uint8_t val) {
#ifdef USECURSES
	if (val == 0) {
		init_pair(1, COLOR_GREEN, COLOR_GREEN);
	}
	if (val == 1) {
		init_pair(1, COLOR_CYAN, COLOR_CYAN);
	}
	if (val == 2) {
		init_pair(1, COLOR_WHITE, COLOR_WHITE);
	}
#endif
}

void pc_exit(void) {
	fclose(messagefile);
#ifdef USECURSES
	endwin();
#endif
	exit(0);
}

void keyboardinput(void) {
	while (1) {
		struct pollfd polls;
		polls.fd = STDIN_FILENO;
		polls.events = (POLLIN | POLLPRI);
		polls.revents = 0;
		int res = poll(&polls, 1, 1);
		if (res > 0) {
			int inp = getc(stdin);
			if (inp == 'w') {
				state_event_put(3);
			}
			if (inp == 's') {
				state_event_put(4);
			}
			if (inp == 'd') {
				state_event_put(1);
			}
			if (inp == 'a') {
				state_event_put(2);
			}
			if (inp == 'e') {
				state_event_put(11); //skip
			}
			if (inp == 'q') {
				pc_exit();
			}
		}
		userthread_yield();
	}
}

int origmain(void);

void firstthread(void) {
	userthread_spawn(keyboardinput);
	origmain();
}

int main(int argc, char ** argv) {
	if (argc != 3) {
		fputs("Please give two parameters: OUTFILE BASEDIR\n", stdout);
		fputs("OUTFILE should be a pipe/file for the played mp3 data\n", stdout);
		fputs("The startinfplay.sh will provide proper parameters\n", stdout);
		return 1;
	}
	initialdir = get_current_dir_name();
	if (initialdir == NULL) {
		fprintf(stderr, "Could not determine current dir\n");
		return 1;
	}
	messagefile = fopen("messages.log", "w");
	if (messagefile == NULL) {
		fprintf(stderr, "Could not create '%s'\n", "messages.log");
		return 1;
	}
	int mp3id = open(argv[1], O_CREAT | O_TRUNC | O_WRONLY);
	if (mp3id < 0) {
		fprintf(stderr, "Open file '%s' failed\n", argv[1]);
		return 1;
	}
	mp3pipe = fdopen(mp3id, "wb");
	if (mp3pipe == NULL) {
		fprintf(stderr, "Create stream for file '%s' failed\n", argv[1]);
		return 1;
	}
	if (chdir(argv[2])) {
		fprintf(stderr, "Change dir to '%s' failed\n", argv[2]);
		return 1;
	}
	basedir = get_current_dir_name();
	if (basedir == NULL) {
		fprintf(stderr, "Could not determine base\n");
		return 1;
	}
	if (sizeof(void *) > 4) {
		puts("WARNING: The segmented buffer is not compatible with 64 bit systems");
	}
	time(&starttime);
	ARTHERCPLDSTART = malloc(sizeof(uint8_t));
	managermemory = malloc(MANAGER_MAXMEM*sizeof(uint8_t));
	NUTBANK_START = (uint32_t)malloc(BUFF_BLOCKSIZE*2);
	//align to 2^n in RAM. (currently n is 19)
	NUTBANK_START += BUFF_BLOCKSIZE;
	NUTBANK_START &= ~(BUFF_INTERNALADDR); //BUFF_INBLOCKMASK would depend on NUTBANK_START
	playervol = malloc(sizeof(PHATVOL));
	playervol->vol_clustsz = 2048;
	playervol->vol_sectsz = 512;
	playervol->vol_numfree = 1000;
	playervol->vol_root_clust = 0;
	playervol->vol_last_clust = 2000;
	FSDEV.dev_dcb = playervol;
	confnet.cdn_ip_addr = 0;
	confnet.cdn_gateway = 0;
#ifdef USECURSES
	initscr(); //for some reason, this may not be called within the user level thread lib
#endif
	userthread_init(firstthread);
	return 1; //should not happen
}
