/* Infplay
  (c) 2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <compiler.h>
#include <stdio.h>
#include <stdint.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <strings.h>
#include <netinet/in.h>
#include "thread/userthread.h"
#include "../bigbuff.h"

uint8_t volatile mp3_pause;
uint32_t volatile mp3_bytes;

void copydata(void) {
	while (1) {
		if (mp3_pause == 0) {
			int i;
			for (i = 0; i < 300; i++) {
				if (buff_avail()) {
					uint8_t databyte = buff_get();
					int res;
					do {
						//unfortunately, opening pipes non-blocking does not work as expected
						res = fwrite(&databyte, 1, 1, mp3pipe);
						if (res == 0) {
							userthread_yield();
						}
					} while (res == 0);
					if (res < 0) {
						puts("Error writing to file");
						break;
					}
					mp3_bytes++;
				} else {
					break;
				}
			}
		}
		usleep(100);
		userthread_yield();
	}
}

void mp3dev_pause1(uint8_t val) {
	uint8_t p = mp3_pause;
	p &= 0xfe;
	p |= val & 1;
	mp3_pause = p;
}

uint8_t mp3dev_pause1_get(void) {
	return mp3_pause & 0x1;
}

void mp3dev_pause2(uint8_t val) {
	uint8_t p = mp3_pause;
	p &= 0xfd;
	p |= val & 2;
	mp3_pause = p;
}

void mp3dev_pause3(uint8_t val) {
	uint8_t p = mp3_pause;
	p &= 0xfb;
	p |= val & 4;
	mp3_pause = p;
}

uint8_t mp3dev_pause2_get(void) {
	return mp3_pause & 0x2;
}

void mp3dev_softarereset(void) {
	mp3_bytes = 0;
}

uint8_t mp3dev_init(void) {
	userthread_spawn(copydata);
	return 0;
}

void mp3dev_volume(uint8_t vol) {
	printf("Volume (%i) change not implemented on PC\n", vol);
}

void mp3dev_bass(uint8_t state) {
	printf("Bass (%i) change not implemented on PC\n", state);
}

uint8_t mp3dev_datarateget(void) {
	return 128;
}

void mp3dev_playtimereset(void) {
	mp3_bytes = 0;
}

uint16_t mp3dev_playtimeget(void) {
	return mp3_bytes/16000;
}
