
#ifndef OTHER_NUTTOUNIX_H
#define OTHER_NUTTOUNIX_H

#include <stdio.h>
#include <sys/device.h>

#define NUTBANK_SIZE 32768



#define WDTO_15MS 15
#define WDTO_2S 2000
#define UART_SETSPEED 9600

#define DEV_DEBUG_NAME "debnull"
#define BLKDEV_NAME "blknull"
extern NUTDEVICE DEV_DEBUG;
extern NUTDEVICE DEV_BLK;
extern NUTDEVICE DEV_FS;

//reduced version
typedef struct {
	uint32_t vol_clustsz;
	uint32_t vol_sectsz;
	uint32_t vol_numfree;
	uint32_t vol_root_clust;
	uint32_t vol_last_clust;
} PHATVOL;


#define FSDEV DEV_FS
#define BLKDEV DEV_BLK

#define WDRF 0

#ifndef _O_RDWR
#define _O_RDWR 0
#endif

#ifndef _O_BINARY
#define _O_BINARY 0
#endif

extern uint8_t volatile SREG;
extern uint8_t volatile MCUCSR;

extern uint32_t NUTBANK_START;

extern uint8_t * ARTHERCPLDSTART;


int NutRegisterDevice (NUTDEVICE *dev, uintptr_t base, uint8_t irq);

int _open (CONST char *name, int mode);
int _close(int fd);
int _ioctl(int fd, int cmd, void * data);
int _fileno(FILE * stream);
FILE * _fdopen(int fd, const char *mode);

void wdt_reset(void);
void wdt_enable(int delay);

int NutEventPost(volatile HANDLE * qhp);

int NutRegisterFtpRoot(CONST char * path);

void pc_exit(void);

#endif
