/* Infplay
  (c) 2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <compiler.h>

#include "../hardware/ks0108drv.h"

#ifdef USECURSES

#include <ncurses.h>

void ks0108_init(void) {
	//initscr(); must be called in main, before the threading starts
	start_color();
	init_pair(1, COLOR_GREEN, COLOR_GREEN);
	init_pair(2, COLOR_BLACK, COLOR_BLACK);
	//init_pair(3, COLOR_RED, COLOR_RED);
}

void ks0108_flush(void) {
	refresh();
}

void ks0108_set_pixel(unsigned char x, unsigned char y, unsigned char color) {
	if ((x < SIZEX) && (y < SIZEY)) {
		if (color) {
			attron(COLOR_PAIR(1));
			mvaddch(y, x, '#');
			attroff(COLOR_PAIR(1));
		} else {
			attron(COLOR_PAIR(2));
			mvaddch(y, x, ' ');
			attroff(COLOR_PAIR(2));
		}
	}
}

void ks0108_clear(void) {
	attron(COLOR_PAIR(2));
	int i, j;
	for (j = 0; j < SIZEY; j++) {
		for (i = 0; i < SIZEX; i++) {
			mvaddch(j, i, ' ');
		}
	}
	attroff(COLOR_PAIR(2));
}

#else

uint8_t display[SIZEX][SIZEY];

void ks0108_init(void) {
}

void ks0108_flush(void) {
	int i, j;
	for (j = 0; j < SIZEY; j++) {
		for (i = 0; i < SIZEX; i++) {
			if (display[i][j]) {
				printf("#");
			} else {
				printf(" ");
			}
		}
		printf("\n");
	}
	printf("\n");
}

void ks0108_set_pixel(unsigned char x, unsigned char y, unsigned char color) {
	if ((x < SIZEX) && (y < SIZEY)) {
		display[x][y] = color;
	}
}

void ks0108_clear(void) {
	int i, j;
	for (i = 0; i < SIZEX; i++) {
		for (j = 0; j < SIZEY; j++) {
			display[i][j] = 0;
		}
	}
}

#endif
