#ifndef SECMALLOC_H
#define SECMALLOC_H


#ifdef NUTDEBUG_HEAP

#define malloc(s) secmalloc_dbg(s, __FILE__, __LINE__)
#define calloc(n, s) seccalloc_dbg(n, s, __FILE__, __LINE__)
#define realloc(p, s) secrealloc_dbg(p, s, __FILE__, __LINE__)
#define free(p) secfree_dbg(p, __FILE__, __LINE__)

extern void * secmalloc_dbg(unsigned short size, CONST char *file, int line);
extern void * secrealloc_dbg(void *ptr, size_t size, CONST char *file, int line);
extern void * seccalloc_dbg(size_t nmemb, size_t size, CONST char *file, int line);
extern void secfree_dbg(void *p, CONST char *file, int line);

#else

#define malloc secmalloc
#define calloc seccalloc
#define realloc secrealloc

extern void * secmalloc(unsigned short size);
extern void * secrealloc(void *ptr, size_t size);
extern void * seccalloc(size_t nmemb, size_t size);
#endif



#endif
