/* Infplay
  (c) 2009-2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <netdb.h>
#include <stdio.h>
#include <sys/confnet.h>
#include <net/route.h>

#include "menu-interpreter.h"
#include "action.h"
#include "network.h"
#include "statestorage.h"

uint8_t neted_ip[4];
uint8_t neted_setid;
uint8_t neted_type;

void neted_drawip(void) {
	visual_print_number(MENU_TEXT_ip1, neted_ip[0]);
	visual_print_number(MENU_TEXT_ip2, neted_ip[1]);
	visual_print_number(MENU_TEXT_ip3, neted_ip[2]);
	visual_print_number(MENU_TEXT_ip4, neted_ip[3]);
}

void neted_convertip(uint32_t ip) {
	neted_ip[0] = (ip);
	neted_ip[1] = (ip >> 8);
	neted_ip[2] = (ip >> 16);
	neted_ip[3] = (ip >> 24);
	neted_drawip();
}

void neted_start_ip(void) {
	neted_type = 0;
	sprintf_P((char *)menu_strings[MENU_TEXT_iptype], PSTR("IP"));
	neted_convertip(confnet.cdn_ip_addr);
}

void neted_start_gw(void) {
	neted_type = 1;
	sprintf_P((char *)menu_strings[MENU_TEXT_iptype], PSTR("Gateway"));
	uint32_t ip;
	NutIpRouteQuery(0, &ip);
	neted_convertip(ip);
}

void neted_start_dns(void) {
	neted_type = 2;
	sprintf_P((char *)menu_strings[MENU_TEXT_iptype], PSTR("DNS"));
	uint32_t ip;
	NutDnsGetConfig2(NULL, NULL, &ip, NULL);
	neted_convertip(ip);
}

void neted_set1(void) {
	neted_setid = 0;
}

void neted_set2(void) {
	neted_setid = 1;
}

void neted_set3(void) {
	neted_setid = 2;
}

void neted_set4(void) {
	neted_setid = 3;
}

void neted_inc(void) {
	neted_ip[neted_setid]++;
	neted_drawip();
}

void neted_dec(void) {
	neted_ip[neted_setid]--;
	neted_drawip();
}

void neted_accept(void) {
	uint32_t ip = (uint32_t)neted_ip[0] | (((uint32_t)neted_ip[1]<<8)) | (((uint32_t)neted_ip[2])<<16) | (((uint32_t)neted_ip[3])<<24);
	if (neted_type == 0) {
		net_setip(ip);
		state_ip_set(ip);
	}
	if (neted_type == 1) {
		net_setgateway(ip);
		state_gateway_set(ip);
	}
	if (neted_type == 2) {
		net_setdns(ip);
		state_dns_set(ip);
	}
	visual_network_upd();
}
