/* Infplay
  (c) 2009-2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Compile as PC test program:
gcc -o metainfoqueue metainfoqueue.c -DTEST_PC -Wall -Wextra

*/

#define META_QUEUESIZE 8
#define META_SHOWTHEFUTURE 3

#include <stdlib.h>
#include <stdio.h>
#include <inttypes.h>
#include <string.h>
#include "metainfoqueue.h"
#include "stringhelper.h"

#ifndef TEST_PC

#include "statestorage.h"
#include "id3.h"
#include "memmapper.h"
#include "bigbuff.h"
#include "hardware/vs1002drv.h"

#endif


typedef struct {
	char * text;
	uint8_t type;
	uint16_t playtimedisplay;
} metainfo_t;

metainfo_t * meta_queue[META_QUEUESIZE];


#ifdef TEST_PC

#include "pctests/avrmapper.h"

#define BUFF_STARTBLOCK 2
#define BUFF_ENDBLOCK 15
#define BUFF_MAXRAM (((BUFF_ENDBLOCK - BUFF_STARTBLOCK +1)*32768)-1)

#ifndef ID3_TITLE
#define ID3_TITLE 0
#endif

#ifndef ID3_ARTIST
#define ID3_ARTIST 1
#endif

#ifndef ID3_ALBUM
#define ID3_ALBUM 2
#endif

uint16_t time;
uint32_t freebuff;

uint16_t mp3dev_playtimeget(void) {
	return time;
}

uint32_t buff_free(void) {
	return freebuff;
}

uint16_t mp3dev_datarateget(void) {
	return 16;
}

void state_id3_set(char * text, uint8_t id) {
	if (id == ID3_TITLE) {
		printf("title: %s\n", text);
	}
	if (id == ID3_ALBUM) {
		printf("album: %s\n", text);
	}
	if (id == ID3_ARTIST) {
		printf("artist: %s\n", text);
	}
}

int main(void) {
	freebuff = BUFF_MAXRAM;
	meta_queueadd("Virtual radio", ID3_ALBUM);
	meta_queueadd("Alpha band", ID3_ARTIST);
	meta_queueadd("Alpha 01", ID3_TITLE);
	meta_queuecheck();
	time = 10;
	freebuff = BUFF_MAXRAM/2;
	meta_queueadd("Alpha band", ID3_ARTIST);
	meta_queueadd("Alpha 01", ID3_TITLE);
	while(time < 50) {
		time++;
		printf("Time: %i\n", time);
		if (time == 15) {
			meta_queueadd("Beta band", ID3_ARTIST);
			meta_queueadd("Beta 01", ID3_TITLE);
		}
		if (time == 17) {
			meta_queueadd("Gamma band", ID3_ARTIST);
			meta_queueadd("Gamma 01", ID3_TITLE);
		}
		meta_queuecheck();
	}
	return 0;
}

#endif


void meta_clear(uint8_t index) {
	if (meta_queue[index] != NULL) {
		free(meta_queue[index]->text);
		free(meta_queue[index]);
		meta_queue[index] = NULL;
	}
}

void meta_queueclear(void) {
	uint8_t i;
	for (i = 0; i < META_QUEUESIZE; i++) {
		meta_clear(i);
	}
}

void meta_queueadd(char * text, uint8_t id) {
	uint8_t i;
	for (i = 0; i < META_QUEUESIZE; i++) {
		if (meta_queue[i] == NULL) {
			metainfo_t * info = s_cmalloc(sizeof(metainfo_t));
			info->text = s_strdup(text);
			info->type = id;
			uint16_t datarate = mp3dev_datarateget();
			if (datarate == 0) { //looks like he is not playing right now
				datarate = 1024; //results in inthefuture = 0
			}
			uint16_t inthefuture = ((BUFF_MAXRAM-buff_free()) / 1024)/datarate;
			/*Having the new title one second in advanced may be nice
			 (and good for recording). Moreover, some stations tend to delay the
			  meta data for a new song a few seconds... partly correcting it by
			  moving another 2 seconds closer. */
			if (inthefuture > META_SHOWTHEFUTURE) {
				inthefuture -= META_SHOWTHEFUTURE;
			}
			//printf("future: %i, rate: %i %s\n", inthefuture, datarate, info->text);
			info->playtimedisplay = mp3dev_playtimeget()+inthefuture;
			meta_queue[i] = info;
			break;
		}
	}
}

void meta_queuecheck(void) {
	uint16_t playtime = mp3dev_playtimeget();
	uint8_t i;
	for (i = 0; i < META_QUEUESIZE; i++) {
		if (meta_queue[i] != NULL) {
			if (meta_queue[i]->playtimedisplay <= playtime) {
				state_id3_set(meta_queue[i]->text, meta_queue[i]->type);
				//printf("%s %i\n", meta_queue[i]->text, meta_queue[i]->type);
				meta_clear(i);
			}
		}
	}
}

