/* Infplay
  (c) 2009 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>
#include <compiler.h>
#include <sys/thread.h>
#include <memdebug.h>
#include "infplay.h"
#include "error.h"
#include "hardware/rs232debug.h"

static void secerr(void * p, size_t s) {
	if (p == NULL) {
		printf_P(PSTR("%s out of mem(%u)\n"), runningThread->td_name, s);
		ThreadTerminate();
	}
#ifndef __NUT_EMULATION__
	if ((p >= (void *)32768) || (p < (void *)(&__heap_start))) { //panic!
		rs232debug_printnum((uint16_t)p);
		error_panic();
	}
#endif
	//rs232debug_printnum((uint16_t)p);
	//rs232debug_printchar('-');
	//rs232debug_printnum((uint16_t)s);
}

#ifdef NUTDEBUG_HEAP
void * s_cmalloc_dbg(unsigned short size, CONST char *file, int line) {
	void * p = dbg_calloc(1, size, file, line);
#else
void * s_cmalloc(unsigned short size) {
	void * p = calloc(1, size);
#endif
	secerr(p, size);
	return p;
}


#ifdef NUTDEBUG_HEAP
void * secmalloc_dbg(unsigned short size, CONST char *file, int line) {
	void * p = dbg_malloc(size, file, line);
#else
void * secmalloc(unsigned short size) {
	void * p = malloc(size);
#endif
	//rs232debug_printchar('M');
	secerr(p, size);
	//rs232debug_printchar('\r');
	//rs232debug_printchar('\n');
	return p;
}

#ifdef NUTDEBUG_HEAP
void * secrealloc_dbg(void *ptr, size_t size, CONST char *file, int line) {
	void * p = dbg_realloc(ptr, size, file, line);
#else
void * secrealloc(void *ptr, size_t size) {
	void * p = realloc(ptr, size);
#endif
	secerr(p, size);
	return p;
}

#ifdef NUTDEBUG_HEAP
void * seccalloc_dbg(size_t nmemb, size_t size, CONST char *file, int line) {
	void * p = dbg_calloc(nmemb, size, file, line);
#else
void *seccalloc(size_t nmemb, size_t size) {
	void * p = calloc(nmemb, size);
#endif
	//rs232debug_printchar('M');
	secerr(p, size);
	//rs232debug_printchar('\r');
	//rs232debug_printchar('\n');
	return p;
}

#ifdef NUTDEBUG_HEAP
void secfree_dbg(void *p, CONST char *file, int line) {
	//rs232debug_printchar('F');
	//rs232debug_printnum((uint16_t)p);
	//rs232debug_printchar('\r');
	//rs232debug_printchar('\n');
	dbg_free(p, file, line);
}
#endif
