/*
 * Copyright (C) 2005 by egnite Software GmbH. All rights reserved.
 * Based on the ftpd example code. Heavily modified (c) 2009 by Malte Marwedel
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holders nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY EGNITE SOFTWARE GMBH AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL EGNITE
 * SOFTWARE GMBH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * For additional information see http://www.ethernut.de/
 *
 */

#define F_CPU 16000000L

#include <stdio.h>
#include <fcntl.h>
#include <io.h>

#include <dev/board.h>
#include <dev/lanc111.h>
#include <dev/debug.h>
#include <dev/pnut.h>
#include <dev/at91_mci.h>
#include <dev/x12rtc.h>
#ifndef __NUT_EMULATION__
#include <fs/phatfs.h>
#endif

#include <sys/confnet.h>
#include <sys/version.h>
#include <sys/heap.h>
#include <sys/thread.h>
#include <sys/timer.h>
#include <sys/socket.h>

#include <arpa/inet.h>
#include <netinet/tcp.h>
#include <net/route.h>
#include <pro/dhcp.h>
#include <pro/ftpd.h>
#include <pro/wins.h>
#include <pro/sntp.h>
#include <pro/discover.h>

/* Determine the compiler. */
#if defined(__IMAGECRAFT__)
#if defined(__AVR__)
#define CC_STRING   "ICCAVR"
#else
#define CC_STRING   "ICC"
#endif
#elif defined(__GNUC__)
#if defined(__AVR__)
#define CC_STRING   "AVRGCC"
#elif defined(__arm__)
#define CC_STRING   "ARMGCC"
#else
#define CC_STRING   "GCC"
#endif
#else
#define CC_STRING   "Compiler unknown"
#endif

/*!
 * \example infplay/infplay.h
 *
 * Media Player with FTP server and Display
 * Tested with the Arthernet board only.
 *
 * This application requires the PNUT file system, which is
 * not available on Ethernut 1.x or Charon II.
 */

/*
 * Baudrate for debug output.
 */
#ifndef DBG_BAUDRATE
#define DBG_BAUDRATE 9600
#endif

/*
 * Wether we should use DHCP.
 */
#define USE_DHCP

/*
 * Wether we should run a discovery responder.
 */
#if defined(__arm__)
#define USE_DISCOVERY
#endif

/*
 * Unique MAC address of the Ethernut Board. Please change before compilation
 *
 * Ignored if EEPROM contains a valid configuration.
 */
#define MY_MAC { 0x00, 0xBE, 0xEF, 0x12, 0x34, 0x56 }

/*
 * Unique IP address of the Ethernut Board on initial boot.
 *
 * Ignored if DHCP is used.
 */
//This is 192.168.1.100
#define INITIAL_IP 3232235876UL

/*
 * IP network mask of the Ethernut Board.
 *
 * Ignored if DHCP is used.
 */
#define MY_IPMASK "255.255.255.0"

/*
 * Gateway IP address for the Ethernut Board on initial boot.
 *
 * Ignored if DHCP is used.
 */
//This is 192.168.1.1
#define INITIAL_GATE 3232235777UL

/*
 * DNS IP address for the Ethernut Board on initial boot.
 *
 * Ignored if DHCP is used.
 */
//This is 85.214.73.63
#define INITIAL_DNS 1440106815UL

/*
 * NetBIOS name.
 *
 * Use a symbolic name with Win32 Explorer.
 */
//#define MY_WINSNAME "ETHERNUT"

/*
 * FTP port number.
 */
#define FTP_PORTNUM 21

/*
 * FTP timeout.
 *
 * The server will terminate the session, if no new command is received
 * within the specified number of milliseconds.
 */
#define FTPD_TIMEOUT 120000

/*
 * TCP buffer size.
 */
#define TCPIP_BUFSIZ 4380

/*
 * Maximum segment size.
 *
 * Choose 536 up to 1460. Note, that segment sizes above 536 may result
 * in fragmented packets. Remember, that Ethernut doesn't support TCP
 * fragmentation.
 */
#define TCPIP_MSS 1460

#if defined(ETHERNUT3)

/* Ethernut 3 file system. */
#define FSDEV       devPhat0
#define FSDEV_NAME  "PHAT0"

/* Ethernut 3 block device interface. */
#define BLKDEV      devNplMmc0
#define BLKDEV_NAME "MMC0"

#elif defined(AT91SAM7X_EK)

/* SAM7X-EK file system. */
#define FSDEV       devPhat0
#define FSDEV_NAME  "PHAT0"

/* SAM7X-EK block device interface. */
#define BLKDEV      devAt91SpiMmc0
#define BLKDEV_NAME "MMC0"

#elif defined(AT91SAM9260_EK)

/* SAM9260-EK file system. */
#define FSDEV       devPhat0
#define FSDEV_NAME  "PHAT0"

/* SAM9260-EK block device interface. */
#define BLKDEV      devAt91Mci0
#define BLKDEV_NAME "MCI0"

#elif defined(ETHERNUT2)

/*
 * Ethernut 2 File system
 */
#define FSDEV       devPnut
#define FSDEV_NAME  "PNUT"

#elif defined(ARTHERNET1)

#define FSDEV       devPhat0
#define FSDEV_NAME  "PHAT0"

#include "hardware/spimmcdrv.h"

#define BLKDEV      devAVRSPIMmc0
#define BLKDEV_NAME "MMC0"


#elif defined(__NUT_EMULATION__)

#define FSDEV_NAME "./"

#define FSDEV_ROOT FSDEV_NAME

#else

#define FSDEV_NAME  "NONE"

#endif

#ifndef FSDEV_ROOT
#define FSDEV_ROOT FSDEV_NAME":/"
#endif

/*! \brief Local timezone, -1 for Central Europe. */
#define MYTZ    -1

/*! \brief IP address of the host running a time daemon. */
#define MYTIMED "130.149.17.21"

#ifdef ETHERNUT3
/*! \brief Defined if X1226 RTC is available. */
#define X12RTC_DEV
#endif

extern uint8_t gfx_pause[];
extern uint8_t gfx_play[];

extern char * ending_mp3;
extern char * ending_url;
extern char * ending_lfm;

/* global functions */
void inf_shutdown(void);
void ThreadTerminate(void) __attribute__((__noreturn__));
void sched_menu_yield(void);
int main(void);
