/* Infplay
  (c) 2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <avr/pgmspace.h>
#include "statestorage.h"
#include "menu-interpreter.h"
#include "memmapper.h"


void info_message(char * text) {
	if (menu_strings[MENU_TEXT_infotext]) {
		free(menu_strings[MENU_TEXT_infotext]);
	}
	//the menu system can accept a NULL in the case there is not enough RAM
	menu_strings[MENU_TEXT_infotext] = (unsigned char *)strdup(text);
	state_event_put(EVENT_SHOWINFO);
}

void info_message_P(PGM_P pgmtext) {
	uint16_t len = strlen_P(pgmtext);
	char * text = s_cmalloc(len+1);
	strcpy_P(text, pgmtext);
	info_message(text);
	free(text);
}

