
#ifndef RS232DEBUG_H
#define RS232DEBUG_H

#include <avr/io.h>
//should define F_CPU:
#include "../infplay.h"
#include <util/delay.h>

/*Very simple char printing, no interrupts, or complex functions.
	Use if there signs of stack corruption or similar faults.
*/

static inline void rs232debug_printchar(char c) {
	UBRR0H = 0;
	UBRR0L = 103; //9600 baud @ 16MHZ
	UCSR0A = (1<<TXC0); //no doublespeed, clear transmit complete
	UCSR0B = (1<<TXEN0);
	//simply wait for completion
	_delay_ms(1.5);
	UDR0 = c;
	_delay_ms(1.5);
}

static inline void rs232debug_printstring(char * text) {
	uint8_t i; //on memory corruption, \0 termination can not be gurateed
	for (i = 0; i < 20; i++){
		char c = *(text+i);
		if (c) {
			rs232debug_printchar(c);
		} else {
			break;
		}
	}
}

static inline void rs232debug_printnum(uint16_t value) {
	uint8_t i;
	for (i = 0; i < 4; i++){
		char c = ((value & 0xF000)>>12)+'0';
		if (c > '9')
			c += 'A'-'0'-10;
		rs232debug_printchar(c);
		value <<= 4;
	}
}

#endif

