/* Infplay
  (c) 2009 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <avr/io.h>
#include <avr/interrupt.h>
#include "../statestorage.h"
#include "../infplay.h"

//300 times per second
#define TIMER1_FIRERATE ((256L*256L)-F_CPU/300/8)

uint8_t oldencoder;
uint8_t presstime;

SIGNAL (SIG_OVERFLOW1) {
	TCNT1 = TIMER1_FIRERATE;
	uint8_t newencoder = PINF & 7;
	//for rotation
	uint8_t siga = newencoder & 4;
	uint8_t osiga = oldencoder & 4;
	if (siga != osiga) {
		if ((osiga) && (!siga)) {
			if (newencoder & 2) {
				state_event_put(4);
			} else
				state_event_put(3);
		}
	}
	//for key press
	if (!(newencoder & 1)) { //if pressed
		if (presstime < 255)
			presstime++;
	} else if (presstime) { //just released
		if (presstime < 75) { //if below 250ms
			state_event_put(1);
		} else
			state_event_put(2);
		presstime = 0;
	}
	oldencoder = newencoder;
}

void rotencoderInit(void) {
	PORTF |= 0x07; //enable pull-up
	TCNT1 = 0;
	TCCR1A = 0;
	TCCR1B = 1<<CS11; //divider: 8
	TCCR1C = 0;
	TIMSK |= 1<<TOIE1;			//enable timer1 interrupt
}
