/************************************************************************/
/*                                                                      */
/*                      RC5 Remote Receiver                             */
/*                                                                      */
/*              Author: Peter Dannegger                                 */
/*                      danni@specs.de                                  */
/*                                                                      */
/************************************************************************/

/*
Modified by Malte Marwedel
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>

#include "rc5decoder.h"

#include "../statestorage.h"
#include "../infplay.h"


#define RC5TIME 	1.778e-3		// 1.778msec
//values with original 0.4, 0.8, 1.2 factors:
//512 cycle: 22, 44, 67
//2048 cycle: 6, 11, 17
//3072 cycle: 4, 7, 11: did work 50% of the times
//4096 cycle: 3, 6, 8: did not work most of the times
#define PULSE_MIN	(uchar)(F_CPU / 3072 * RC5TIME * 0.3 + 0.5)
#define PULSE_1_2	(uchar)(F_CPU / 3072 * RC5TIME * 0.7 + 0.5)
#define PULSE_MAX	(uchar)(F_CPU / 3072 * RC5TIME * 1.3 + 0.5)


uchar	rc5_bit;				// bit value
uchar	rc5_time;				// count bit time
uint	rc5_tmp;				// shift bits in

SIGNAL (SIG_OUTPUT_COMPARE2) {
  uint tmp = rc5_tmp;				// for faster access

  if( ++rc5_time > PULSE_MAX ){			// count pulse time
    if( !(tmp & 0x4000) && tmp & 0x2000 )	{// only if 14 bits received
       state_rc5_rec(tmp); //handle recived value
		}
    tmp = 0;
  }

  if( (rc5_bit ^ xRC5_IN) & 1<<xRC5 ){		// change detect
    rc5_bit = ~rc5_bit;				// 0x00 -> 0xFF -> 0x00

    if( rc5_time < PULSE_MIN )			// too short
      tmp = 0;

    if( !tmp || rc5_time > PULSE_1_2 ){		// start or long pulse time
      if( !(tmp & 0x4000) )			// not too many bits
        tmp <<= 1;				// shift
      if( !(rc5_bit & 1<<xRC5) )		// inverted bit
        tmp |= 1;				// insert new bit
      rc5_time = 0;				// count next pulse time
    }
  }
  rc5_tmp = tmp;
}

void rc5Init(void) {
	//assume timer is disabled after power up
	TCNT2 = 0;
	//divisor
	TCCR2 = (1<<CS22) | (1<<WGM21); //divider 256, CTC mode
	OCR2 = 12; //12 * 256 = 3072 cycle
	TIMSK |= 1<<OCIE2;			//enable timer2 compare interrupt
}
