/* Infplay
  (c) 2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <avr/io.h>

#include "lcdbacklight.h"

/* Possible improvement:
DDRE Pin 3 is the PWM output of a timer. This would allow
a much finer brightness controll
*/

void backlight_set(uint8_t brightness) {
	if (brightness == 1) {
		BACKLIGHT_DDR &= ~(1<<BACKLIGHT_PIN);
		BACKLIGHT_PORT |= (1<<BACKLIGHT_PIN);
	}	else if (brightness == 2) {
		BACKLIGHT_DDR |= (1<<BACKLIGHT_PIN);
		BACKLIGHT_PORT |= (1<<BACKLIGHT_PIN);
	} else {
		BACKLIGHT_DDR &= ~(1<<BACKLIGHT_PIN);
		BACKLIGHT_PORT &= ~(1<<BACKLIGHT_PIN);
	}
}
