
#ifndef KS0108DRV_H
  #define KS0108DRV_H

#include "../infplay.h"

#define SIZEX 128
#define SIZEY 64

#define LCD_DATAPORT  PORTD
#define LCD_DATADDR  DDRD
#define LCD_CONTROLPORT PORTE
#define LCD_CONTROLDDR DDRE

#define LCD_PIN_CS1 6
#define LCD_PIN_CS2 7
#define LCD_PIN_E 2
#define LCD_PIN_RS 5

//the longer delay routines to use
#define LCD_WAIT1000 NutSleep(1000)
#define LCD_WAIT120 NutSleep(120)

//enable to show all segments at init for a short time
//#define LCD_TEST

//call once, before calling any of the other functions
void ks0108_init(void);

//writes the data to the lcd, takes ~26456 ticks at 16MHz
void ks0108_flush(void);

//sets the pixel in the buffer
void ks0108_set_pixel(unsigned char x, unsigned char y, unsigned char color);

//clears the buffer (does not write to the LCD)
void ks0108_clear(void);

//for advanced usage, such as scrolling or contrast
void ks0108_send_sys(unsigned char command);

#endif
