
#ifndef SED1560_DRIVER_H
  #define SED1560_DRIVER_H

#include "../infplay.h"

#define SIZEX 100
#define SIZEY 64

#define LCD_DATAPORT  PORTD
#define LCD_DATADDR  DDRD
#define LCD_CONTROLPORT PORTE
#define LCD_CONTROLDDR DDRE

#define LCD_PIN_CS1 2
#define LCD_PIN_RW 3
#define LCD_PIN_A0 6
#define LCD_PIN_RES 7

//the longer delay routines to use
#define LCD_WAIT1000 NutSleep(1000)
#define LCD_WAIT120 NutSleep(120)

//enable to show all segments at init for a short time
//#define LCD_TEST

//call once, before calling any of the other functions
void sed1560_init(void);

//writes the data to the lcd, takes ~26456 ticks at 16MHz
void sed1560_flush(void);

//sets the pixel in the buffer
void sed1560_set_pixel(unsigned char x, unsigned char y, unsigned char color);

//clears the buffer (does not write to the LCD)
void sed1560_clear(void);

//for advanced usage, such as scrolling or contrast
void sed1560_send_sys(unsigned char command);

//simple contrast settings, range: 0x00 ... 0x1F
void sed1560_set_contrast(uint8_t value);

#endif
