/* Infplay
  (c) 2009-2010 by Malte Marwedel
  www.marwedels.de/malte

  This file is mostly compied from examples from Nut/OS.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "infplay.h"
#include "statestorage.h"

/*
 * FTP service.
 *
 * This function waits for client connect, processes the FTP request
 * and disconnects. Nut/Net doesn't support a server backlog. If one
 * client has established a connection, further connect attempts will
 * be rejected.
 *
 * Some FTP clients, like the Win32 Explorer, open more than one
 * connection for background processing. So we run this routine by
 * several threads.
 */
void FtpService(void)
{
    TCPSOCKET *sock;

    /*
     * Create a socket.
     */
    if ((sock = NutTcpCreateSocket()) != 0) {

        /*
         * Set specified socket options.
         */
#ifdef TCPIP_MSS
        {
            u_short mss = TCPIP_MSS;
            NutTcpSetSockOpt(sock, TCP_MAXSEG, &mss, sizeof(mss));
        }
#endif
#ifdef FTPD_TIMEOUT
        {
            u_long tmo = FTPD_TIMEOUT;
            NutTcpSetSockOpt(sock, SO_RCVTIMEO, &tmo, sizeof(tmo));
        }
#endif
#ifdef TCPIP_BUFSIZ
        {
            u_short siz = TCPIP_BUFSIZ;
            NutTcpSetSockOpt(sock, SO_RCVBUF, &siz, sizeof(siz));
        }
#endif

        /*
         * Listen on our port. If we return, we got a client.
         */
        puts_P(PSTR("FTP Thread running"));
        if (NutTcpAccept(sock, FTP_PORTNUM) == 0) {
            printf_P(PSTR("FTP connected %s\n"), inet_ntoa(sock->so_remote_addr));
            NutFtpServerSession(sock);
            printf_P(PSTR("FTP disconnected %s\n"), inet_ntoa(sock->so_remote_addr));
        } else {
            puts_P(PSTR("FTP connect failed"));
        }

        /*
         * Close our socket.
         */
        NutTcpCloseSocket(sock);
    }
}

/*
 * FTP service thread.
 */
/* 1x done by the network thread */

/*
THREAD(FtpThread, arg)
{
	while(!state_devinit_get(INIT_FTPROOT_DONE)) {
		NutSleep(500);
	}
	state_devinit_set(INIT_FTP_DONE);
	// Loop endless for connections.
	for (;;) {
		FtpService();
	}
}
*/