#ifndef FILEMANAGER_H
#define FILEMANAGER_H

//only needed for the pc emulation
extern void * managermemory;

#define MANAGER_MAXMEM 16384
//#define MANAGER_MAXMEM 1024


#ifndef TEST_PC

#include "bigbuff.h"
#include "error.h"

#define MAN_LOCK banking_displayuse();
#define MAN_UNLOCK banking_displayrelease();
#define MAN_BE_NICE NutThreadYield();


//start at the uppermost 16KB
#define MAN_STARTADDR 49152

#endif


void manager_buildup(char *rootdir);
uint8_t manager_buildup_busy_get(void);
uint16_t manager_filecount(void);
char * manager_filenameget(uint16_t id, char * rootdir);
void manager_sortnames(char * rootdir);
uint16_t manager_fileidget(char * filename);
uint16_t manager_nextfileid(char * filename);
uint16_t manager_prevfileid(char * filename);
uint16_t manager_randomfileid(void);
uint16_t manager_randomfilenearid(char * filename);
uint16_t manager_nextfolderfileid(char * filename);
void manager_abort(void);

#endif
