/* Infplay
  (c) 2009-2010 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "infplay.h"
#include <avr/io.h>
#include <util/delay.h>
#include <avr/pgmspace.h>
#include "error.h"
#include "statestorage.h"
#include "menu-interpreter.h"
#include "memmapper.h"
#include "hardware/lcdbacklight.h"
#include "hardware/rs232debug.h"

void error_panic(void) {
	uint8_t sreg = SREG;
	cli();
	rs232debug_printchar('E');
	rs232debug_printchar('P');
	if (!(sreg & 0x80)) {
		rs232debug_printchar('i');
	} else {
		rs232debug_printstring(runningThread->td_name);
	}
	rs232debug_printchar('\r');
	rs232debug_printchar('\n');
	while(1) {
		//flicker LCD backlight until watchdog bites
		BACKLIGHT_PORT |= (1<<BACKLIGHT_PIN);
		uint8_t i;
		for (i = 0; i < 200; i++) {
			_delay_ms(1.0);
		}
		BACKLIGHT_PORT &= ~(1<<BACKLIGHT_PIN);
		for (i = 0; i < 200; i++) {
			_delay_ms(1.0);
		}
	}
}

void error_message(char * text) {
	if (menu_strings[MENU_TEXT_errortext]) {
		free(menu_strings[MENU_TEXT_errortext]);
	}
	//the menu system can accept a NULL in the case there is not enough RAM
	menu_strings[MENU_TEXT_errortext] = (unsigned char *)strdup(text);
	state_event_put(EVENT_SHOWERROR);
}

void error_message_P(PGM_P pgmtext) {
	uint16_t len = strlen_P(pgmtext);
	char * text = s_cmalloc(len+1);
	strcpy_P(text, pgmtext);
	error_message(text);
	free(text);
}

void error_diropen(char * dirname) {
	printf_P(PSTR("Error opening dir '%s'\n"), dirname);
}

void error_general(uint8_t errornum) {
	printf_P(PSTR("E:%i\n"), errornum);
}
