#ifndef BIGBUFF_H
#define BIGBUFF_H

#include <dev/board.h>

/*
The emulation can not use a segmented address space,
so the trick is to use the segmented address space with
just a single large segment.

Note: This code uses bitmasks for addresses, so it is
important to align the addresses and size to theses
bitmasks.
This means: The sementsize must be 2^n. The Highest
valid address of a segmend must be (2^n-1)+x*(2^n).
This restrictions result in a start address of
the form x*(2^n).
*/


#ifndef __NUT_EMULATION__

#define BUFF_STARTBLOCK 2
#define BUFF_ENDBLOCK 15
//must be 2^n
#define BUFF_BLOCKSIZE NUTBANK_SIZE
#define BUFF_TOOBIGADDR 0x10000

//must be able to store a maximum real address
typedef uint16_t BUFF_SEGDATATYPE;

#else

/*Currently, this would not work with 64 bit address.
If you use a 64bit system, replace all uint32_t in
bigbuff.c and bigbuff.h by uint64_t should be
sufficient.

*/

#define BUFF_STARTBLOCK 2
#define BUFF_ENDBLOCK 2

#define BUFF_BLOCKSIZE 524288

#define BUFF_TOOBIGADDR (BUFF_MAXRAM+NUTBANK_START+1)

typedef uint32_t BUFF_SEGDATATYPE;

#endif

#define BUFF_MAXRAM (((BUFF_ENDBLOCK - BUFF_STARTBLOCK +1)*BUFF_BLOCKSIZE)-1)
//generate bitmasks. if BUFF_BLOCKSIZE is not 2^n, this would fail
#define BUFF_INBLOCKMASK (BUFF_BLOCKSIZE-1)
#define BUFF_INTERNALADDR (BUFF_BLOCKSIZE-1)

extern volatile uint8_t buff_block_rp;
extern volatile BUFF_SEGDATATYPE buff_byte_rp;
extern volatile uint8_t buff_block_wp;
extern volatile BUFF_SEGDATATYPE buff_byte_wp;
extern volatile uint8_t bank_c;

void banking_set(uint8_t bank);

void banking_displayuse(void);
void banking_displayrelease(void);

void buff_set_dual_rp_mode(uint8_t state);
void buff_copy_tofile(FILE * f, uint32_t size);
void buff_copy_tofile_follow(FILE * f);

void buff_init(void);

#if defined(BUFF_TESTMODE) || defined (__NUT_EMULATION__)

uint8_t buff_get(void);

#endif

static inline uint8_t buff_avail(void) {
	if ((buff_block_rp != buff_block_wp) || (buff_byte_rp != buff_byte_wp)) {
		return 1;
	}
	return 0;
}

uint32_t buff_free(void);

size_t buff_filecopy(FILE * f, size_t s);

//#define BUFF_TESTMODE

#ifdef BUFF_TESTMODE

void buff_put(uint8_t * data, uint16_t datalen);

/* Make sure the file system is mounted befor calling and set a proper file name
The proper test filename must be set in the source code!
NOTE: Will take several minutes to finish, while there is no
thread swich. Disable the watchdog before calling!
*/
void buff_test(void);
#endif

#endif
