#!/bin/bash

SRCDIR=final1
NUTVER="4.8.6"
NUTBASE=ethernut

checkerr () {
  RETCODE=$?
  if [ $RETCODE -ne 0 ] ; then
  echo "build_everything.sh: The previous command returned with status $RETCODE, indicating an error, exiting"
  exit 1
  fi
}

if [ -d "$NUTBASE/ethernut-$NUTVER" ] ; then

echo "build_everything.sh: There is already a directory '$NUTBASE/ethernut-$NUTVER'."
echo "build_everything.sh: Please remove everything from '$NUTBASE' except the tar.bz2 source file."
exit 1

fi

if [ -d "$NUTBASE/nutapp_arthernet" ] ; then

echo "build_everything.sh: There is already a directory '$NUTBASE/nutapp_arthernet'."
echo "build_everything.sh: Please remove everything from '$NUTBASE' except the tar.bz2 source file."
exit 1

fi

if [ -d "$NUTBASE/nutbld_arthernet" ] ; then

echo "build_everything.sh: There is already a directory '$NUTBASE/nutbld_arthernet'."
echo "build_everything.sh: Please remove everything from '$NUTBASE' except the tar.bz2 source file."
exit 1

fi

if [ -d "$NUTBASE/nut" ] || [ -f "$NUTBASE/nut" ] ; then

echo "build_everything.sh: There is already a directory or file '$NUTBASE/nut'."
echo "build_everything.sh: Please remove everything from '$NUTBASE' except the tar.bz2 source file."
exit 1

fi

BASEDIR=`pwd`

if [ ! -d "$NUTBASE" ] ; then

mkdir "$NUTBASE"

fi

cd "$NUTBASE"

if [ ! -d "bin" ] ; then

mkdir "bin"

fi

if [ ! -f "ethernut-$NUTVER.tar.bz2" ] ; then

echo "build_everything.sh: Nut/OS source not found, will download (~9MB) it from the internet in 10 seconds..."

sleep 10

wget http://www.ethernut.de/arc/ethernut-$NUTVER.tar.bz2
checkerr

fi

echo "build_everything.sh: Decompressing..."

bunzip2 -k "ethernut-$NUTVER.tar.bz2"
checkerr

tar -xf "ethernut-$NUTVER.tar"
checkerr

rm "ethernut-$NUTVER.tar"
checkerr

echo "build_everything.sh: Create directory structure..."

ln -s "ethernut-$NUTVER" "nut"
checkerr

cd nut
checkerr

echo "build_everything.sh: Configure..."

./configure --prefix="$BASEDIR/$NUTBASE"
checkerr

echo "build_everything.sh: Compile..."

make
checkerr

make install
checkerr

cd "$BASEDIR"

PATH="$BASEDIR/$NUTBASE/bin:$PATH"

export PATH

#copy own file for arthernet
cp "$SRCDIR/nutos-ext/arthernet1b.conf" "$NUTBASE/ethernut-$NUTVER/conf/"
checkerr

cd $NUTBASE

echo "build_everything.sh: Configure target... (if nutconfigure is not found, you need to install lua5.1, liblua5.1, liblua5.1-0-dev)"

nutconfigure -c nut/conf/arthernet1b.conf -a nutapp_arthernet -b nutbld_arthernet create-buildtree
checkerr

nutconfigure -c nut/conf/arthernet1b.conf -a nutapp_arthernet -b nutbld_arthernet create-apptree
checkerr

cd "$BASEDIR"

echo "build_everything.sh: Include own bugfixes..."

#1 add directory to allow examples to install
mkdir "$NUTBASE/nut/bin/atmega128"
checkerr

cd "$BASEDIR/$NUTBASE/ethernut-$NUTVER"
checkerr

#2 fix nutinit.c

patch "arch/avr/os/nutinit.c" "$BASEDIR/$SRCDIR/nutos-ext/nutinit.c.patch"
checkerr

#3 correct free heap calculations if debugging is enabled

patch "os/heap.c" "$BASEDIR/$SRCDIR/nutos-ext/heap.c.patch"
checkerr

#4 work around crashes if out of memory

patch "include/memdebug.h" "$BASEDIR/$SRCDIR/nutos-ext/memdebug.h.patch"
checkerr

cp "$BASEDIR/$SRCDIR/nutos-ext/secmalloc.h" "$BASEDIR/$NUTBASE/"
checkerr

#5 fix connection errors if the connection is closed very short after opening

patch "net/tcpsm.c" "$BASEDIR/$SRCDIR/nutos-ext/tcpsm.c.patch"
checkerr

echo "build_everything.sh: Include own improvements..."

#make code more compact

patch "Makedefs.avr-gcc" "$BASEDIR/$SRCDIR/nutos-ext/Makedefs.avr-gcc.patch"
checkerr

patch "app/Makedefs.avr-gcc" "$BASEDIR/$SRCDIR/nutos-ext/Makedefs.avr-gcc.apppatch"
checkerr

#debugging and sector buffer enable
pwd
echo "$BASEDIR/$SRCDIR/nutos-ext/UserConf.mk" "$BASEDIR/$NUTBASE/nutbld_arthernet/"

cp "$BASEDIR/$SRCDIR/nutos-ext/UserConf.mk" "$BASEDIR/$NUTBASE/nutbld_arthernet/"
checkerr

cp "$BASEDIR/$SRCDIR/nutos-ext/UserConf.mk" "$BASEDIR/$NUTBASE/nutapp_arthernet/"
checkerr

#several FTP improvements

cd "$BASEDIR/$NUTBASE/ethernut-$NUTVER"
checkerr

patch "pro/ftpd.c" "$BASEDIR/$SRCDIR/nutos-ext/ftpd.c.patch"
checkerr

patch "include/pro/ftpd.h" "$BASEDIR/$SRCDIR/nutos-ext/ftpd.h.patch"
checkerr

#speed improvements for mount and first write

patch "fs/phat32.c" "$BASEDIR/$SRCDIR/nutos-ext/phat32.c.patch"
checkerr

patch "fs/phatvol.c" "$BASEDIR/$SRCDIR/nutos-ext/phatvol.c.patch"
checkerr

#exta improvements for counting free clusters with a seperate thread - faster mount

patch "fs/phatvol.c" "$BASEDIR/$SRCDIR/nutos-ext/phatvol.c.patch2"
checkerr

#sd-hc support and spi on multiple devices

patch "dev/mmcard.c" "$BASEDIR/$SRCDIR/nutos-ext/mmcard.c.patch"
checkerr

patch "include/dev/mmcard.h" "$BASEDIR/$SRCDIR/nutos-ext/mmcard.h.patch"
checkerr

#correct netbuf out of memory problems, replace malloc/free routines and add debugging feature

patch "dev/netbuf.c" "$BASEDIR/$SRCDIR/nutos-ext/netbuf.c.patch"
checkerr

patch "include/dev/netbuf.h" "$BASEDIR/$SRCDIR/nutos-ext/netbuf.h.patch"
checkerr

#improve DNS resolve (increase time-out if first try failed and add out of memory check)

patch "pro/resolv.c" "$BASEDIR/$SRCDIR/nutos-ext/resolv.c.patch"
checkerr

#replace NutHeapAlloc by malloc/free routines to get the advantages of secmalloc.h

patch "net/tcpsock.c" "$BASEDIR/$SRCDIR/nutos-ext/tcpsock.c.patch"
checkerr

patch "os/timer.c" "$BASEDIR/$SRCDIR/nutos-ext/timer.c.patch"
checkerr

patch "crt/vfscanf_p.c" "$BASEDIR/$SRCDIR/nutos-ext/vfscanf_p.c.patch"
checkerr

patch "crt/vsscanf_p.c" "$BASEDIR/$SRCDIR/nutos-ext/vsscanf_p.c.patch"
checkerr

patch "crt/vfprintf_p.c" "$BASEDIR/$SRCDIR/nutos-ext/vfprintf_p.c.patch"
checkerr

patch "crt/vsprintf_p.c" "$BASEDIR/$SRCDIR/nutos-ext/vsprintf_p.c.patch"
checkerr

patch "fs/fat.c" "$BASEDIR/$SRCDIR/nutos-ext/fat.c.patch"
checkerr

sleep 2

echo "build_everything.sh: Compile Nut/OS..."

cd "$BASEDIR/$NUTBASE/nutbld_arthernet"
checkerr

make clean all install
checkerr

echo "build_everything.sh: The examples wont compile because they will miss the memmapper source"

#cd "$BASEDIR/$NUTBASE/nutapp_arthernet"
#checkerr

#make clean all install
#checkerr

echo "build_everything.sh: Compile Streamplay..."

cd "$BASEDIR"

cp "$SRCDIR/nutos-ext/Makedefs" .
checkerr

cp "$NUTBASE/nutapp_arthernet/Makerules" .
checkerr

cd "$BASEDIR/$SRCDIR"

make clean all
checkerr

avr-size *.hex

echo "build_everything.sh: The AVR build was successful. Building the PC programs"

sleep 5

cd "$BASEDIR/$SRCDIR/pctests"

make
checkerr

cd "$BASEDIR/$SRCDIR/pcbuild"

make links
checkerr

make
checkerr

make ncurses
checkerr

echo "build_everything.sh: compiled $SRCDIR/infplay.hex"
echo "build_everything.sh: compiled $SRCDIR/pcbuild/infplay"
echo "build_everything.sh: compiled $SRCDIR/pcbuild/infplay-ncurses"
echo "build_everything.sh: compiled various test programs in $SRCDIR/pctests/"
echo "build_everything.sh: Done"
