/*
   Gamebox
    Copyright (C) 2004-2006  by Malte Marwedel
    m.marwedel AT onlinehome dot de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "main.h"

u08 volatile TCCR1B;
u16 volatile TCNT1;


long long volatile timer1_prev = -1;

unsigned long long get_time10k(void) {
struct timeval data1;
unsigned long long time10k;
//10000=10k ist eine Sekunde
gettimeofday (&data1, NULL);
time10k = data1.tv_sec*10000+data1.tv_usec/100;
return time10k;
}

void timer1_sim(int foo) {
unsigned long long currenttime, delta;
if (TCCR1B) {
  currenttime = get_time10k();
  delta = abs(currenttime - timer1_prev);
  //printf("Timer Update: %lld, delta: %lld\n",currenttime,delta);
  if (TCCR1B == 0x04) {
    //TCNT1 muss 32768 mal pro Sec hoch-zhlen
    TCNT1 += (u16)((float)delta*3.2768);
  }
  timer1_prev = currenttime;
  glutTimerFunc(1,timer1_sim, 0); //alle 1 ms
} else { //Timer ist aus, muss nicht so oft aufgerufen werden
  glutTimerFunc(20,timer1_sim, 0); //alle 20 ms
  timer1_prev = get_time10k();     //Ungefhren Anfangswert bereithalten
}
}

void waitms(uint16_t zeitms) {
long long oldtime, targettime, currtime;
if (no_delays != 1) {
  oldtime = get_time10k();
  targettime = oldtime + zeitms*17/2; //Mglichst realistisch am AVR dran
  for (;;) {
    currtime = get_time10k();
    if (currtime >= targettime) { //Delay erreicht
      break;
    }
    if (currtime < oldtime) { //berlauf (vermutlich Mitternacht)
      break; //Ist zwar falsch, aber einmalig pro Tag wohl zu tolerieren ;-)
    }
  }
}
}
