#ifndef MAIN_H
 #define MAIN_H

//der eingestellte Takt
#define F_CPU 8000000
/*Falls der interne Oszillator verwendet wird, sollte mit dem Programmer einmal
das entsprechende Calibrierungsbyte ausgelesen und fr osccaleradout
gesetzt werden. Dieser Wert kann sich von Chip zu Chip unterscheiden!
Bei falschen Werten luft der Chip zu schnell oder zu langsam.
Der osccaleradout Wert wird dann beim Programmstart in das OSCCAL Register
geschrieben. Wird ein externer Takt verwendet, so hat dies keine Bedeutung.
*/
#define osccaleradout 0xad

/*Berechnung der Timer Geschwindigkeit.
Der Timer2 soll alle 4800mal pro Sekunde auslsen. (100Hz*16Zeilen*3Durchlufe)
Der Prescaler des Timers ist 8. Der timer luft bis 255 und ruft dann den
Interrupt auf. Daraus folgt:
4800 = (F_CPU/8)/(255-timerset)
umgestellt:
255-timerset = (F_CPU/8)/4800
255 = (FCPU/8)/4800)+timerset
255-((FCPU/8)/4800) = timerset
*/
#define timerset_test (255-(F_CPU/8/4800))

#if (timerset_test < 0)
#define timerset 0
#else
#define timerset (uint8_t)timerset_test
#endif

#if (timerset_test > 174)
#error "Der gewhlte Takt ist zu langsam. 4MHZ sind Minnimum, 8MHZ werden empfohlen"
#endif

/* Berechnen des Wertes fr waitms. dieser Wert ist abhngig von F_CPU und
der Zeit die von der Interrupt Routine bentigt wird
Jeder Durchlauf durch die Interruptroutine bentigt rund 538 Takte,
Angenommen der Systemtakt liegt innerhalb von 3-11MHZ, so wird der Interrupt
4800 mal aufgerufen, was 2582400 Take pro Sekune sind.
eigentlich msste F_CPU_msdelay als((F_CPU-(2582400))/4000) definiert sein.
Allerdings passt die Geschwindigkeit besser, wenn statt durch 4000 durch 5000
geteilt wird, da ich beim Schreiben der Demo die genaue Rechenzeit der Interrupt
Routine nicht genau ermittelt hatte und pauschal von 50% fr die Interrupts
Routine ausging. Somit sind die verwendeten Delayzeiten in der Demos selbst
etwas zu gro.
*/
#define F_CPU_msdelay (uint16_t)((F_CPU-(2582400))/5000)

//Externe Funktionen
#include <avr/io.h>
#include <inttypes.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/delay.h>
#include <avr/pgmspace.h>
#include <math.h>

//Um zu wissen fr was uint8_t u.s.w. steht siehe inttypes.h
typedef uint8_t  u08;
typedef int8_t   s08;
typedef uint16_t u16;
typedef int16_t  s16;

#include "graphicint.h"
#include "graphicfunctions.h"
#include "text.h"
#include "gameoflife.h"

//Funktionsprototypen:
void fill_1(void);
void fill_2(void);
void fill_3(void);
void intro(void);
void house(void);
void life(void);
void patterns(void);
void dotrigometric(void);
void doanimations(void);
int main(void);

#endif

