#ifndef GRAPHICFUNCTIONS_H
 #define GRAPHICFUNCTIONS_H


/* Wenn auf 1 gesetzt, so wird bei jedem verwenden von pixel_set eine
 Bereichsberprfung vorgenommen
Nachteil: Mehr Code und Langsamer
Allerdings wird derzeit pixel_set so oder so nicht verwendet,
nheres dazu siehe graphicfunctions.c
*/
#define pixel_set_always_safe 0

//universeller Speicher fr eine Spalte/Zeile + 0 Zeichen
extern uint8_t linebuff[maxscreen+1];
extern uint8_t no_delays;


void clear_buff(void);
void load_buff(PGM_VOID_P x);

static __inline__ void pixel_set(uint8_t posx, uint8_t posy, uint8_t color) {
#if (pixel_set_always_safe == 1)
if ((posx < screenx) && (posy < screeny)) {
  gdata[posy][posx] = color;
}
#else
  gdata[posy][posx] = color;
#endif
}


/* pixel_get ist leider nicht so kompakt wie das direkte verwenden
   von gdata[y][x] im Programmcode
   Daher verwende ich diese Makro nich in anderen Funktionen
*/
static __inline__ uint8_t pixel_get(uint8_t posx, uint8_t posy) {
  return gdata[posy][posx];
}

void pixel_set_safe(uint8_t posx, uint8_t posy, uint8_t color);
void insert_buff_x(uint8_t y);
void insert_buff_y(uint8_t x);
void waitms(uint16_t zeitms);
void move_line_down (uint8_t x);
void move_down (void);
void move_line_up (uint8_t x);
void move_up (void);
void move_line_right (uint8_t y);
void move_right (void);
void move_line_left (uint8_t y);
void move_left (void);
void draw_line (uint8_t posx, uint8_t posy, int8_t lengthx, int8_t lengthy,
                uint8_t color, uint8_t overlay);
void flip_color(void);
void draw_box (uint8_t startx, uint8_t starty, uint8_t lengthx, uint8_t lengthy,
               uint8_t outercolor, uint8_t innercolor);

#endif
