
#include "main.h"
#include "gameoflife.h"

/*Die Game-of-life Funktionen bentigen ungefhr 386 Byte Flash
Um in der Demo immer die gleichen Resultate unabhngig der 'Auflsung' zu
erhalten verwende ich hier eine feste Gre von 16x16 Punkten und nicht
die durch screenx und screenx angegebene Gre.
Eine Anpassung an andere 'Auflsungen' drfe aber nicht schwierig sein.
Datum der letzten nderung: 2005-05-07
*/

u08 is_object(u08 px, u08 py) {
u08 the_data;

if ((px < 16) && (py < 16)) {
  the_data = gdata[py][px];
  the_data &= 0x30; //extrahiere grne Daten
  if (the_data == 0) {
    return 0;
  } else {
    return 1;
  }
}
return 0;
}

u08 getneighbour(u08 posx, u08 posy){
u08 alive;
u08 nposx,nposy;
//Errechnet wieviele Nachbar Lebewesen leben.
 //rechte Position
 nposx = posx+1;
 nposy = posy;
 alive = is_object(nposx,nposy);
 //linke Position
 nposx = posx-1;
 nposy = posy;
 alive += is_object(nposx,nposy);
 //obere Position
 nposx = posx;
 nposy = posy-1;
 alive += is_object(nposx,nposy);;
 //untere Position
 nposx = posx;
 nposy = posy+1;
 alive += is_object(nposx,nposy);
 //rechte obere Position
 nposx = posx+1;
 nposy = posy-1;
 alive += is_object(nposx,nposy);
 //linke obere Position
 nposx = posx-1;
 nposy = posy-1;
 alive += is_object(nposx,nposy);
 //rechte untere Position
 nposx = posx+1;
 nposy = posy+1;
 alive += is_object(nposx,nposy);
 //linke untere Position
 nposx = posx-1;
 nposy = posy+1;
 alive += is_object(nposx,nposy);
return alive;
}

u08 whattodo(u08 posx, u08 posy){
u08 usedfield;
usedfield = getneighbour(posx,posy);
  if (is_object(posx,posy) == 0) { //frei
    if (usedfield == 3) { //beginne zu leben
      return 0x40;//schwaches grn - beginne zu leben
    } else {
      return 0x00; //pixel aus - bleibe frei
    }
  } else {   //ende wenn frei; Wenn bereits lebt
    if ((usedfield > 3) || (usedfield < 2)) {//wenn zu viel oder zu wenig
      return 0x04; //gestorben - schwaches rot
    } else {
      return 0xc0; //bleibe am leben - starkes grn
    }
  }//ende wenn bereits lebt
}




void gameoflife_step(void) {
/* 1: Basierend auf den grnen Inhalt erstelle neues Display in unbenutztem
      Speicherteil
   2: berschreibe angezeige Daten mit dem unsichtbarem Teil
*/
u08 posx,posy;
u08 the_data;
//Die eigentlichen Berechungen
for (posx = 0; posx < 16; posx++) {
  for (posy = 0; posy < 16; posy++) {
    the_data = gdata[posy][posx]; //lade Daten
    the_data &= 0x33;//lsche unsichtbare Daten
    the_data |= whattodo(posx,posy);
    gdata[posy][posx] = the_data;
  }
}
//Kopieren der Daten
for (posx = 0; posx < 16; posx++) {
  for (posy = 0; posy < 16; posy++) {
    gdata[posy][posx] = gdata[posy][posx] >> 2;
  }
}
}
