/* lcd.h
Header file for lcd.c.

Copyright (C) 2006-2007, 2017 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LCD_H
 #define LCD_H

//The ohm symbol in the lcd character set, decimal number=244
#define OHM_SYMB "\xf4"
#define LEFTARROW_SYMB "\x7f"
#define RIGHTARROW_SYMB "\x7e"
#define BATTERY_SYMB "\x01"
#define BATTERY_SYMB_CHAR '\x01'
#define DELTA_SYMB "\x02"
#define DEGREE_SYMB "\xdf"

void lcd_putchar(uint8_t ch);
void lcd_clear(void);
void lcd_init(void);
void lcd_backlightOn(void);
void lcd_backlightOff(void);

/*internal use only:
static void lcd_set_4bit(u08 ch);
static void lcd_send(u08 ch);
static void lcd_send_char(u08 ch);
static void lcd_send_sys(u08 sys);
static void lcd_init(void);
*/

#endif
