/*
  (c) 2008, 2017 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

uint8_t volatile press_mode;

void keys_init(void) {
	TCCR2B = (1<<CS22) | (1<<CS21) | (1<<CS20); //prescaler = 1024
	TCNT2 = 0;
	TIMSK2 = (1<<TOIE2); //interrupt enabled
	PORTD = (1<<PD2) | (1<<PD3); //enable pullups
}

uint8_t keys_pressed(void) {
	cli();
	uint8_t tmp = press_mode;
	press_mode = 0;
	sei();
	return tmp;
}

uint8_t volatile presscountA = 0;
uint8_t volatile presscountB = 0;

//used for main loop timing control
volatile uint8_t g_tick;

//timer prescaler = 1024, timer overflows after 256 counts
#define TRIGGERSHORT F_CPU/1024UL/256UL/10UL

#define TRIGGERLONG F_CPU/1024UL/256UL

ISR(TIMER2_OVF_vect) {
	g_tick++;
	//Key A pressed
	if ((PIND & (1<<PD3)) == 0) {
		if (presscountA != 0xff) {
			presscountA++;
		}
	}
	//Key B pressed
	if ((PIND & (1<<PD2)) == 0) {
		if (presscountB != 0xff) {
			presscountB++;
		}
	}
	//both keys are realeased
	if ((PIND & ((1<<PD2) | (1<<PD3))) == ((1<<PD2) | (1<<PD3))) {
		if ((presscountA) && (presscountB)) {
			if ((presscountA > (TRIGGERSHORT)) &&
			    (presscountB > (TRIGGERSHORT))) { //100ms pressed
				press_mode = 5;
			}
			if ((presscountA > (TRIGGERLONG)) &&
			    (presscountB > (TRIGGERLONG))) { //1s pressed
				press_mode = 6;
			}
		} else {
			if (presscountA > (TRIGGERSHORT)) { //100ms pressed
				press_mode = 1;
			}
			if (presscountA > (TRIGGERLONG)) { //1s pressed
				press_mode = 2;
			}
			if (presscountB > (TRIGGERSHORT)) { //100ms pressed
				press_mode = 3;
			}
			if (presscountB > (TRIGGERLONG)) { //1s pressed
				press_mode = 4;
			}
		}
		presscountA = 0;
		presscountB = 0;
	}
	TCNT2 = 0;
}
