/*
Simple four channel signal sampler. Multimeter mode.

    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

void slowad_loop(void) {
/* Transmitting protocol:
12Bit A/D Convertet by oversampling. Transmitting Ch1 Ch2 Ch3 Ch4 Ch1...
First a high Byte with the MSB set, with the channel number and 5 A/D Bits is
transmitted, then a low Byte with the MSB = 0 an the  reaming (lower) 7 A/D Bits
is transmitted. Then this repeats with the next channel
*/
u08 channel, nun;
u16 data[4], datat;
u08 datal, datah;

while (ADCSRA & (1<<ADSC));	//Wait until previous conversion is complete
//Converter enabled, clock divider 128
ADCSRA = (1<<ADEN)|(1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0);
sei();				//the UART Receive interrupt must work
while(back_to_main == 0) {
  for (nun = 0; nun < 32; nun++) {
    for (channel = 0; channel < 4; channel++) {
      ADMUX = (1<<REFS0) | channel;
      ADCSRA |= (1<<ADSC);		//Start next conversion
      while (ADCSRA & (1<<ADSC));	//Wait until conversion is complete
      datat = ADCL;
      datat |= ADCH<<8;
      data[channel] += datat;
    }
  }
  for (nun = 0; nun < 4; nun++) {
    data[nun] = data[nun]>>3;		//12 Bit value
    datah = 0x80+(nun<<5)+(data[nun]>>7);
    while ((UCSRA  & (1<<UDRE)) == 0);	//Wait until UDR is empty
    _delay_us(3.0);
    UDR = datah;			//Write datah to UART
    datal = data[nun] & 0x7f;		//Extract lower 7 Bit
    while ((UCSRA  & (1<<UDRE)) == 0);	//Wait until UDR is empty
    _delay_us(3.0);
    UDR = datal;			//Write datal to UART
    data[nun] = 0;			//Clear for next sampling
  }
}
cli();
back_to_main = 0;
}
