/*
Simple four channel signal sampler.

    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef MAIN_H
 #define MAIN_H

//#define F_CPU 11059200
#define F_CPU 14745600
//#define F_CPU 18432000

#define baud9600val (F_CPU/(9600*16l)-1)
#define baud115200val (F_CPU/(115200*16l)-1)
#define baud230400val (F_CPU/(230400*16l)-1)

#define devicetype "001"
//Unique number for every device
#define devicenr "001"
#define devicesw "002"

#define led_on() PORTD |= (1<<PD7)
#define led_off() PORTD &= ~(1<<PD7)
#define led_toogle() PORTD = (PORTD & ~(1<<PD7)) | ((~(PORTD & (1<<PD7))) & (1<<PD7))

#include <avr/io.h>
#include <avr/interrupt.h>
#include <inttypes.h>
#include <avr/wdt.h>
#include <string.h>
#include <avr/pgmspace.h>
#include <util/delay.h>

typedef unsigned char  u08;
typedef unsigned short u16;

register unsigned char back_to_main asm("r4");

#include "fastdigi.h"
#include "fastad.h"
#include "slowad.h"
#include "dds.h"

void delayms(u16 ms);
int main(void);
void print(char* s);
void uart_put(char value);
char uart_wait_get(void);
u08 hextoint(char c);
u08 checkvoltage(void);
u08 calcvoltage(u16 data);
void putnumber(u08 val);

#endif
