/*
Simple four channel signal sampler. Hi speed digital sampling.

    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

//If you use an version of avr-libc before 1.4, you need this:
//#define ISR(TIMER2_COMP_vect) SIGNAL(SIG_OUTPUT_COMPARE2)
//otherwise comment it out.


register unsigned char valold asm("r2");	//Stores previous sample
register unsigned char readno asm("r17");	//How often the sample was equal

register unsigned char val asm("r16");		//local variable in timer ISR

u08 volatile fifo_tx[256];			//The FIFO
register unsigned char fifo_wp asm("r3");	//FIFO write pointer
u08 fifo_rp = 0;				//FIFO read pointer



ISR(TIMER2_COMP_vect) {			//Samples the input pins
val = PINC;				//Reads the input ports
asm volatile ("andi r16,lo8(15)");	//Assembler is faster here
if ((val != valold) || (readno >= 0x0f)) {	//New data Byte to send
  if (fifo_tx[fifo_wp] == 0) {		//If FIFO is free
    //readno = readno <<4;
    asm volatile ("swap r17");		//Again assembler is faster
    asm volatile ("andi r17, 0xf0");
    asm volatile ("or r17, r2");	//readno |= valold;
    fifo_tx[fifo_wp] = readno;		//Put data into FIFO
    fifo_wp++;				//Next FIFO adress
    readno = 0;				//None new reads so far
  }
}
valold = val;		//The current value will be the previous value next time
readno++;				//We read one value in this interrupt
}

void fastdigit_loop(void) {
u16 nun;
//Timer2 init
TCNT2 = 0;		//Timer2 reset
OCR2 = 73;		//75,23KHZ sample rate at 11.0592MHZ
TIMSK = 1 << OCIE2;	//Compare match int active
TCCR2 = (1 << WGM21);	//Clear timer on compare match
TCCR2 |= (1 << CS20);	//Prescaler = 1
//Initialize register variables
valold = 0x0f;
readno = 0;
//Initialize FIFO as void
for (nun = 0; nun < 256; nun++) {
  fifo_tx[nun] = 0;	//Zero has the meaning of empty in this FIFO
}
fifo_wp = 0;		//FIFO write pointer start adress
sei();			//Interrupts enabled
while (back_to_main == 0) {		//Endless loop which frees FIFO
  while (!(UCSRA & (1<<UDRE)));	//Wait until UART is ready
  while (fifo_tx[fifo_rp] == 0);	//Wait until FIFO contains data
  UDR = fifo_tx[fifo_rp];	//Send data
  fifo_tx[fifo_rp] = 0;		//Mark memory as free
  fifo_rp++;			//Increase reading pointer
}
cli();
back_to_main = 0;
TCCR2 = 0;
TIMSK &= ~(1 << OCIE2);
}

