/*
Simple four channel signal sampler. Low speed analog sampling.

    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

void fastad_loop(void) {
/* Transmitting protocol:
7Bit A/D Convertet. Transmitting Ch1 Ch2 Ch3 Ch4 Ch1...
The A/D data are in the 7 lower Bits. The MSB is set, if the data is from
channel 1. otherwise the MSB is cleared.

*/
u08 data, c_channel = 0;

while (ADCSRA & (1<<ADSC));	//Wait until previous conversion is complete
ADCSRA = (1<<ADEN)|(1<<ADPS2)|(1<<ADPS1);//Converter enabled, clock divider 64
ADMUX = (1<<REFS0) | (1<<ADLAR);//New conversation uses channel 0 (Ch1)
ADCSRA |= (1<<ADSC);		//Start next conversion
sei();				//the UART Receive interrupt must work
while(back_to_main == 0) {
  while (ADCSRA & (1<<ADSC));	//Wait until conversion is complete
  data = ADCH;			//Get data
  ADMUX = (1<<REFS0) | (1<<ADLAR) | c_channel;	//Results are left-adjusted
  				//and channel select + internal reference
  ADCSRA |= (1<<ADSC);		//Start next conversion
  data = data>>1;		//Reduce from 8 to 7 Bit
  if (c_channel == 1) {		//c_channel is already one higher than data is!
    data |= 0x80;		//Mark value as from channel 1
  }
  while ((UCSRA  & (1<<UDRE)) == 0);	//Wait until UDR is empty
  UDR = data;			//Write data to UART
  c_channel++;
  c_channel &= 0x03;		//Lets the value go from 0..3
}
cli();
back_to_main = 0;
}
