/*
Simple four channel signal sampler. Signal generator.

    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "main.h"

void dds_loop(void) {
/* Transmitting protocol:
The program needs the data in hex ascii values. First the upper, then the lower
part of a value.
First the delay has to be transmitted (4 values), then the table has to be
transmitted (256 times 2 values)
*/
u08 table[256];
u08 index = 0;
u16 delay = 0;
index = UDR;		//Just clear the register in the case of old data
//Load delay
for (index = 0; index < 4; index++) {
  delay = delay <<4;
  delay += hextoint(uart_wait_get());
}
//Load table for values
index = 0;
do {
  table[index] = hextoint(uart_wait_get())<<4;
  table[index] |= hextoint(uart_wait_get());
  index++;
} while(index);
print("\rK\n");
DDRB = 0xff;
sei();				//the UART receive interrupt must work
while(back_to_main == 0) {	//3 Cycles (Main loop)
  PORTB = table[index];		//6 Cycles
  _delay_loop_2(delay);		//4*delay cycles (delay must be greater zero)
  index++;			//1 Cycle (overflow is intended)
}
PORTB = 0;
DDRB = 0;
cli();
back_to_main = 0;
}
