/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

int mouse_down;

void input_key_cursor (int key, int x, int y) {
if (op_mode == 1) {
  if (key == GLUT_KEY_LEFT) {
    m1_drawingstate_offset = fmaxf((m1_drawingstate_offset-0.1),0.0);
    m1_clearscreen();
  }
  if ((key == GLUT_KEY_RIGHT) && ((m1_drawingstate_offset+0.9) < m1_overview)) {
    m1_drawingstate_offset += 0.1;
    m1_clearscreen();
  }
}
if (op_mode == 2) {
  if (key == GLUT_KEY_LEFT) {
    m2_drawingstate_offset = fmaxf((m2_drawingstate_offset-0.1),0.0);
    m2_clearscreen();
  }
  if ((key == GLUT_KEY_RIGHT) && ((m2_drawingstate_offset+0.9) < m2_overview)) {
    m2_drawingstate_offset += 0.1;
    m2_clearscreen();
  }
}
screen_text_update();
}

void input_key_key(unsigned char key, int x, int y) {
if (key == 'q') {
  exit_app();
}
if (key == 'c') {
  glutSetWindow(windowid_main);
  glClear(GL_COLOR_BUFFER_BIT);
}
if (key == 'h') {
  if (show_help) {	//Then hinde window
    show_help = 0;
    glutSetWindow(windowid_help);
    glutHideWindow();
    glutSetWindow(windowid_main);
    glClear(GL_COLOR_BUFFER_BIT);
  } else {		//Otherwise show it
    show_help = 1;
    glutSetWindow(windowid_help);
    glutShowWindow();
    glutSetWindow(windowid_main);
  }
}
if (key == 'l') {
  if (show_about) {	//Then hinde window
    show_about = 0;
    glutSetWindow(windowid_about);
    glutHideWindow();
    glutSetWindow(windowid_main);
    glClear(GL_COLOR_BUFFER_BIT);
  } else {		//Otherwise show it
    show_about = 1;
    glutSetWindow(windowid_about);
    glutShowWindow();
    glutSetWindow(windowid_main);
  }
}
if (key == 'a') {
  device_mode_select(1);
  glutSetWindow(windowid_main);
  glClear(GL_COLOR_BUFFER_BIT);
  fifo_clear();
  glutTimerFunc(1,m1_getandcompress, 0);  //Reads FIFO and draws
}
if (key == 'o') {
  device_mode_select(2);
  glutSetWindow(windowid_main);
  glClear(GL_COLOR_BUFFER_BIT);
  fifo_clear();
  glutTimerFunc(1,m2_getandprepare, 0);  //Reads FIFO and draws
}
if (key == 'm') {
  device_mode_select(3);
  glutSetWindow(windowid_main);
  glClear(GL_COLOR_BUFFER_BIT);
  fifo_clear();
  glutTimerFunc(1,m3_getandprepare, 0);  //Reads FIFO and draws
}
if (key == 's') {
  device_mode_select(4);
  glutSetWindow(windowid_main);
  glClear(GL_COLOR_BUFFER_BIT);
  fifo_clear();
  m4_datafieldavr_clear();
  m4_printinfo();			//Shows screen
  m4_uploaddata();			//Uploads wave in AVR
}
if (op_mode == 1) {
  if ((key == '+')  && (m1_scale < 2)) {
    m1_scale *= 2.0;
    m1_clearscreen();
  }
  if (key == '-') {
    m1_scale /= 2.0;
    m1_clearscreen();
  }
  if (m1_logicmode == 1) {
    if ((key >= '0') && (key <= '7')) {	//Key for logic pressed
      m1_logictable[key-48] = 1-m1_logictable[key-48]; //Toggle
      glutSetWindow(m1_windowid_logic);
      glutPostRedisplay();
      glutSetWindow(windowid_main);
    }
  } else {
    if (key == '1') {  //Toggels bit 0
      m1_triggermask = (m1_triggermask & ~0x01) | (((~m1_triggermask) & 0x01));
    }
    if (key == '2') {  //Toggels bit 1
      m1_triggermask = (m1_triggermask & ~0x02) | (((~m1_triggermask) & 0x02));
    }
    if (key == '3') {  //Toggels bit 2
      m1_triggermask = (m1_triggermask & ~0x04) | (((~m1_triggermask) & 0x04));
    }
    if (key == '4') {  //Toggels bit 3
      m1_triggermask = (m1_triggermask & ~0x08) | (((~m1_triggermask) & 0x08));
    }
  }
  if (key == 'D') {
    m1_overview += 0.25;
  }
  if (key == 'd') {
    m1_overview = fmaxf(1.0, m1_overview-0.25);
    m1_drawingstate_offset = fminf(m1_overview-0.9, m1_drawingstate_offset);
  }
  if (key == 'e') {		//Both/Risig/Falling edge
    m1_triggermode += 1;
    if (m1_triggermode > 2) {
      m1_triggermode = 0;
    }
  }
  if (key == 't') {
    m1_logicmode++;		//Toggle mode
    if (m1_logicmode > 2) {
      m1_logicmode = 0;
    }
    glutSetWindow(m1_windowid_logic);
    if (m1_logicmode == 1) {
      glutShowWindow();
    } else {
      glutHideWindow();
    }
    glutPostRedisplay();
    glutSetWindow(windowid_main);
  }
}
if (op_mode == 2) {
  if ((key == '+')  && (m2_scale < 2)) {
    m2_scale *= 2.0;
    m2_clearscreen();
  }
  if (key == '-') {
    m2_scale /= 2.0;
    m2_clearscreen();
  }
  if (key == '1') {  //Toggels bit 0
    m2_triggermask = (m2_triggermask & ~0x01) | (((~m2_triggermask) & 0x01));
  }
  if (key == '2') {  //Toggels bit 1
    m2_triggermask = (m2_triggermask & ~0x02) | (((~m2_triggermask) & 0x02));
  }
  if (key == '3') {  //Toggels bit 2
    m2_triggermask = (m2_triggermask & ~0x04) | (((~m2_triggermask) & 0x04));
  }
  if (key == '4') {  //Toggels bit 3
    m2_triggermask = (m2_triggermask & ~0x08) | (((~m2_triggermask) & 0x08));
  }
  if (key == 'D') {
    m2_overview += 0.25;
  }
  if (key == 'd') {
    m2_overview = fmaxf(1.0, m2_overview-0.25);
    m2_drawingstate_offset = fminf(m2_overview-0.9, m2_drawingstate_offset);
  }
  if (key == 'e') {		//Both/Risig/Falling edge
    m2_triggermode += 1;
    if (m2_triggermode > 2) {
      m2_triggermode = 0;
    }
  }
  if ((key == 'V') && (m2_triggerlevel < 127)) {
    m2_triggerlevel++;
  }
  if ((key == 'v') && (m2_triggerlevel > 0)) {
    m2_triggerlevel--;
  }
}
if (op_mode == 4) {
  if (key == 'w') {
    m4_predev_datafield((m4_currwave+1)%m4_max_modes);
  }
  if ((key == 'F') && (m4_delay > 1)) { //Frequency fine tuning
    m4_delay--;
  }
  if ((key == 'f') && (m4_delay < 65535)) {
    m4_delay++;
  }
    if ((key == '+') && (m4_delay > 1)) { //Frequency fast tuning
    m4_delay /= 2;
    if (m4_delay < 1) {
      m4_delay = 1;
    }
  }
  if ((key == '-') && (m4_delay < 65535)) {
    m4_delay *= 2;
    if (m4_delay > 65535) {
      m4_delay = 65535;
    }
  }
}
screen_text_update();
}

void mousepress(int button, int state, int x, int y) {
if ((button ==  GLUT_LEFT_BUTTON) && (state == GLUT_DOWN)) {
  mouse_down = 1;
  if (op_mode == 4) {
    m4_curveadjust(x,y);
  }
} else {
  mouse_down = 0;
}
}

void mousemove(int x, int y) {
if (op_mode == 4) {
  if (mouse_down == 1) {
    m4_curveadjust(x,y);
  }
}
}
