/*
RS232 I/O routines
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef SIMPLERS232_H
  #define SIMPLERS232_H

//rs232_manymessages = 0: no printf info
//rs232_manymessages = 1: printf info about important things (recommend)
//rs232_manymessages = 2: printf info about every action
#define rs232_manymessages 1


//Default byaudrate with which is used by serial_open()
//#define baud B115200
//#define baud B230400
#define baud B9600



//Number of ports defined in portnames
#define portno 6

int fd_rs232;
const char portnames[portno][14];
char rs232recbuf[255];

void serial_clear(void);
int serial_speed(speed_t newbaud);
int serial_open(const char *port_wish);
int serial_put(char* s);
int serial_put_char(char s);
int serial_get(void);
int serial_get_fast(void);
void serial_close(void);

#endif
