/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

float m1_drawingstate = 0;	//Position in screen cords
float m1_scale = 0.0001;	//Scale for dawing
float m1_drawingstate_offset = 0; //Move graph to left or right side
float m1_overview = 1; 		//Factor of what is more samplet than on screen,
                       		//within this left and right shift is possible

int m1_samples_since_trigger;	//Since last trigger occurence...

int m1_triggermode = 0;		//0: Rising/falling 1: Rising 2: Falling
int m1_triggermask;		//Which pins have an active trigger

int m1_oldval, m1_oldr;		//Used by m1_getandcompress

int m1_logicmode = 0;		//0: Normal mode; 1,2: active; 1: window shown
int m1_logictable[8];		//Codes the logic function

int m1_windowid_logic;		//For the window to select the logic function

int m1_samples_on_screen(void) {
  return (int)(1.0/(m1_scale));
}

void m1_clearscreen(void) {
glutSetWindow(windowid_main);
glClear(GL_COLOR_BUFFER_BIT);
m1_printinfo();
}

void m1_getandcompress(int foo) {	//Get data from serial port and compress
int newval, newr;
unsigned char trg_oval, trg_nval;
while (fifo_data[fifo_rp] >= 0) {	//Loop to compress and draw values
  newval = m1_logicfunc(fifo_data[fifo_rp] & 0x000f);	//The value
  newr = (fifo_data[fifo_rp] & 0x00f0)>>4;	//Times of value
  m1_samples_since_trigger += newr;
  samples_c += newr;				//Count for stats
  fifo_rp_next();				//Update read pointer
  //Compress the values to reduce line drawing calls
  if ((newval == m1_oldval) && (m1_oldr < (m1_samples_on_screen()/10))) {
    m1_oldr += newr;				//Just add the times
  } else {
    m1_drawgraph(m1_oldval,m1_oldr);		//Draw old values
    //Trigger set back
    if ((m1_triggermask) && (newval != m1_oldval) &&
        ((m1_samples_since_trigger >= m1_samples_on_screen()*m1_overview))) {
      trg_oval = (m1_oldval & m1_triggermask);
      trg_nval = (newval & m1_triggermask);
      if ((m1_triggermode == 0) && (trg_oval != trg_nval)) { //Rising/falling
        m1_drawingstate = 0.0;
        m1_samples_since_trigger = 0;
        triggerrate_c++;		//Count for stats
      }
      if (m1_triggermode == 1) { //Rising edge
        //Seach if one pin went from 0 to 1
        if (((trg_oval & 1) < (trg_nval & 1)) ||
            ((trg_oval & 2) < (trg_nval & 2)) ||
            ((trg_oval & 4) < (trg_nval & 4)) ||
            ((trg_oval & 8) < (trg_nval & 8))) {
          m1_drawingstate = 0.0;
          m1_samples_since_trigger = 0;
          triggerrate_c++;		//Count for stats
        }
      }
      if (m1_triggermode == 2) { //Falling edge
        //Seach if one pin went from 1 to 0
        if (((trg_oval & 1) > (trg_nval & 1)) ||
            ((trg_oval & 2) > (trg_nval & 2)) ||
            ((trg_oval & 4) > (trg_nval & 4)) ||
            ((trg_oval & 8) > (trg_nval & 8))) {
          m1_drawingstate = 0.0;
          m1_samples_since_trigger = 0;
          triggerrate_c++;		//Count for stats
        }
      }
    } //End: Trigger active
    m1_oldval = newval;
    m1_oldr = newr;
  } //End: There was something drawn
} //End: Data in FIFO
if (op_mode == 1) {			//Only recall if still in this mode
  glutTimerFunc(15,m1_getandcompress, 0); //Recall this function after 15ms
}
}

void m1_drawgraph(int val, int times) {
/*We get the values in val and the length of the lines in times
  the current drawing position is m1_drawingstate and m1_drawingstate_offset
  is an offset for shiftig eveything left
  m1_scale ... scales the drawing horizontally
  in the case m1_drawingstate reaches m1_overview and m1_triggermask is 0 we
  start from the beginning with m1_overview = 0
*/

float peg; //Pegel, needed for the lines
if (m1_drawingstate > m1_overview) { //Limmit line starting position
  m1_drawingstate = m1_overview;
}
float l_len = ((float)times)*m1_scale; 	//Line length
if ((l_len + m1_drawingstate) > m1_overview) { //Limmit line length
  l_len = m1_overview-m1_drawingstate;
}
float l_start = m1_drawingstate-m1_drawingstate_offset; //point to start line
float l_end = l_start+l_len;	//End of line
m1_drawingstate +=l_len;	//New state for next time
//The screen goes from -1 to 1 and not 0..1 so we need to calc (val*2) lengths
// and (val*2)-1 absolute cordinates
//float s_len = l_len*2.0; //Screen line length
float s_start = l_start*2.0-1.0;
float s_end = l_end*2.0-1.0;
//Reset m1_drawingstate if needed
if ((m1_drawingstate >= m1_overview) && (m1_triggermask == 0)) {
  m1_drawingstate = 0.0;
}
//Remove old drawing
glPushMatrix();
glBegin(GL_QUADS);		//Begin drawing a quadrilateral
glColor3f(1.0, 1.0, 1.0);	//white color
glVertex2f(s_start, 0.1);	//Left botton corner
glVertex2f(s_end+0.05, 0.1);	//Right botton corner
glVertex2f(s_end+0.05, 0.87);	//Right top corner
glVertex2f(s_start, 0.87);	//Left top corner
glEnd();
glPopMatrix();
glPushMatrix();
glBegin(GL_QUADS);		//Begin drawing a 2.quadrilateral
glColor3f(1.0, 1.0, 1.0);	//white color
glVertex2f(s_start, -0.76);
glVertex2f(s_end+0.05, -0.76);
glVertex2f(s_end+0.05, -0.1);
glVertex2f(s_start, -0.1);
glEnd();
glPopMatrix();
//Draw the value1
glPushMatrix();
glColor3f(1.0,0.3,0.3);
glBegin(GL_LINES);
peg = ((float)(val & 0x1))*(0.1);
glVertex2f(s_start, +0.75+peg);
glVertex2f(s_end, +0.75+peg);
glEnd();
glPopMatrix();
//Draw the value2
glPushMatrix();
glColor3f(0.2,1.0,0.2);
glBegin(GL_LINES);
peg = ((float)((val>>1) & 0x1))*(0.1);
glVertex2f(s_start, +0.25+peg);
glVertex2f(s_end, +0.25+peg);
glEnd();
glPopMatrix();
//Draw the value3
glPushMatrix();
glColor3f(0.1,0.1,1.0);
glBegin(GL_LINES);
peg = ((float)((val>>2) & 0x1))*(0.1);
glVertex2f(s_start, -0.25+peg);
glVertex2f(s_end, -0.25+peg);
glEnd();
glPopMatrix();
//Draw the value4
glPushMatrix();
glColor3f(0.8,0.5,0.0);
glBegin(GL_LINES);
peg = ((float)((val>>3) & 0x1))*(0.1);
glVertex2f(s_start, -0.75+peg);
glVertex2f(s_end, -0.75+peg);
glEnd();
glPopMatrix();
glutPostRedisplay();
glutPostOverlayRedisplay();
}

void m1_printinfo(void) {
int nun;
float samples_per_pix;
char label[200], labelb[200];
glutSetWindow(windowid_main);
//Write scale
glColor3f (0.0, 0.0, 0.0);
glRasterPos2f (-0.95, 0.9);
samples_per_pix = 1/(m1_scale*windowwidth);
sprintf(label, "Samples per pixel: %f", samples_per_pix);
draw_white_rectangle(-1.0,1.0,-0.4,0.86);	//Clear old text
drawstring(label);
//Write trigger
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.4, 0.9);
if (m1_triggermask) {			//If trigger
  strcpy(label,"");
  strcpy(labelb,"");
  for (nun = 0; nun < 4; nun++) {	//Make list where triggers are active
    if (m1_triggermask & (0x01<<nun)) {
      sprintf(label, "%s %i",labelb,(nun+1));
    }
    sprintf(labelb,"%s", label);
  }					//List now in labelb
  if (m1_triggermode == 0) {
    sprintf(label,"Rising/falling trigger on inputs%s active",labelb);
  }
  if (m1_triggermode == 1) {
    sprintf(label,"Rising trigger on inputs%s active",labelb);
  }
  if (m1_triggermode == 2) {
    sprintf(label,"Falling trigger on inputs%s active",labelb);
  }
} else {
  sprintf(label, "Trigger is off");
}
draw_white_rectangle(-0.4,1.0,0.25,0.86);	//Clear old text
drawstring(label);
//Write View
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(0.25, 0.9);
sprintf(label,"%i %s of screen shown, start offset: %i %s",
        (int)((1.0/m1_overview)*100.0),"%",(int)(m1_drawingstate_offset*100.0), "%");
draw_white_rectangle(0.25,1.0,1.0,0.86);	//Clear old text
drawstring(label);
//Write stats
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.95, -0.9);
sprintf(label, "Data rate: %i byte/s Sample rate: %i 1/s Trigger rate: %i 1/s",
        datarate_l, samples_l, triggerrate_l);
draw_white_rectangle(-1.0,-1.0,0.20,-0.755);	//Clear old text
drawstring(label);
//4. Channel normal or logic mode
  draw_white_rectangle(0.2,-1.0,0.60,-0.755);	//Clear old text
if (m1_logicmode) {
  glColor3f(0.0, 0.0, 0.0);
  glRasterPos2f(0.2, -0.9);
  drawstring("Ch4 in logic mode");
}
//FIFO load
if (fifo_max_l >= 95) {
  glColor3f (1.0, 0.0, 0.0);
} else {
  glColor3f (0.0, 0.0, 0.0);
}
glRasterPos2f(0.6, -0.9);
sprintf(label, "max FIFO usage: %i %s",fifo_max_l,"%");
draw_white_rectangle(0.6,-1.0,1.0,-0.755);	//Clear old text
drawstring(label);
//Write stats
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(-0.2, -0.05);
sprintf(label, "Screen shows %f ms",
        samples_per_pix*windowwidth*1000/gsamples_l);
draw_white_rectangle(-1.0,0.11,1.0,-0.11);	//Clear old text
drawstring(label);
glutPostRedisplay();
}

int m1_logicfunc(int val) {
//Adapts the fourth graph if logicmode is active
if (m1_logicmode == 0) {	//Not Active exit
  return val;
}
val &= 0x7;			//Extract only channel 1..3
int state = m1_logictable[val] & 1; //Get new value for channel 4
val |= (state << 3);		//Puts new value as channel 4
return val;
}

void m1_showlogic(void) {
char label[200];
int nun;
glutSetWindow(m1_windowid_logic);
glViewport(0, 0, 350, 200);
glMatrixMode(GL_PROJECTION);
glLoadIdentity();
gluOrtho2D(0.0, 1.0, 0.0, 1.0);
glClearColor(0.8, 1.00, 1.00, 1.0);
glClear(GL_COLOR_BUFFER_BIT);		//Clear screen now
glColor3f(0.5, 0.5 , 0.5);
glBegin(GL_LINE_LOOP);
glVertex2f(0.0, 0.0);
glVertex2f(0.0, 0.999);
glVertex2f(0.999, 0.999);
glVertex2f(0.999, 0.0);
glEnd();
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f(0.3, 0.9);
sprintf(label, "Logic for Channel 4");
drawstring(label);
glRasterPos2f(0.1, 0.75);
sprintf(label, "Key: 0   1   2   3   4   5   6   7");
drawstring(label);
glRasterPos2f(0.1, 0.6);
sprintf(label, "Ch1: 0   1   0   1   0   1   0   1");
drawstring(label);
glRasterPos2f(0.1, 0.5);
sprintf(label, "Ch2: 0   0   1   1   0   0   1   1");
drawstring(label);
glRasterPos2f(0.1, 0.4);
sprintf(label, "Ch3: 0   0   0   0   1   1   1   1");
drawstring(label);
glRasterPos2f(0.1, 0.25);
sprintf(label, "Out: 0   0   0   0   0   0   0   0");
for (nun = 0; nun < 8; nun++) { //Sets '1' in output string if 1 in table
  if (m1_logictable[nun]) {
    label[5+nun*4] = '1';
  }
}
drawstring(label);
glRasterPos2f(0.1, 0.1);
sprintf(label,"Press Number (1..7) to toggle output, 't' hides window");
drawstring_small(label);
glutSetWindow(windowid_main);
}
