/*
Simple four channel signal plot.
    Copyright (C) 2006  by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "main.h"

int windowid_main;		//ID for main window
int windowid_about;		//ID for about window
int windowid_help;		//ID for help window
int windowid_scan;              //ID for scan window
int windowwidth = 1000;		//Main window width
int windowheight = 400;		//Main window height

int show_about = 0;		//Show/ hinde about window
int show_help = 1;		//Show/hide help
int show_scan = 0;

char scan_text[200] = "Loading...";

float cursor_screenaxis_x(int x) {
  return (((float)x)/((float)windowwidth)*2.0-1.0);
}

float cursor_screenaxis_y(int y) {
  return (((float)y)/((float)windowheight)*2.0-1.0);
}

void draw_white_rectangle(float startx, float starty, float stopx, float stopy) {
//Draws a white rectangle (useful for clearing an area)
glPushMatrix();
glBegin(GL_QUADS);
glColor3f(1.0, 1.0, 1.0);		//White color
glVertex2f(startx, starty);
glVertex2f(stopx, starty);
glVertex2f(stopx, stopy);
glVertex2f(startx, stopy);
glEnd();
glPopMatrix();
}

void screen_text_update_foo(int foo) {
//glutVisibilityFunc needs a function with a parameter...
screen_text_update();
}

void screen_text_update(void) {
if (op_mode == 0) {
  glutSetWindow(windowid_main);
  glClear(GL_COLOR_BUFFER_BIT);
  if (show_help == 0) {
    printscan_updatetext("You should select an operating mode");
  }
}
if (op_mode == 1) {
  m1_printinfo();
}
if (op_mode == 2) {
  m2_printinfo();
}
if (op_mode == 3) {
  m3_printinfo();
}
if (op_mode == 4) {
  m4_printinfo();
}
glFlush();
}

void hide_scan(int foo) {
if (show_scan == 1) {
  glutSetWindow(windowid_scan);
  glutHideWindow();
  show_scan = 0;
  glutSetWindow(windowid_main);
}
if (show_scan > 1) {
  show_scan--;
}
}

void printscan_updatetext(char *s) {
if (strlen(s) < 200) {
  glutSetWindow(windowid_scan);
  show_scan++;
  glutShowWindow();
  glutTimerFunc(2000,hide_scan, 0);
  glutSetWindow(windowid_main);
  strcpy(scan_text,s);
  printscan();
} else
  printf("printscan_updatetext: Error: Text too long, cant update\n\r");
}

void printscan(void) {
glutSetWindow(windowid_scan);
glViewport(0, 0, 400, 80);
glMatrixMode(GL_PROJECTION);
glLoadIdentity();
gluOrtho2D(0.0, 1.0, 0.0, 1.0);
glClearColor(0.8, 0.8, 0.8, 1.0);
glClear(GL_COLOR_BUFFER_BIT);		//Clear screen now
glColor3f(0.5, 0.5 , 0.5);
glBegin(GL_LINE_LOOP);			//It should look like a box
glVertex2f(0.0, 0.0);
glVertex2f(0.0, .999);
glVertex2f(0.999, 0.999);
glVertex2f(0.999, 0.0);
glEnd();
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f (0.1, 0.5);
drawstring(scan_text);
glRasterPos2f (0.1, 0.2);
drawstring_verysmall("In a case of an error, please see console output for more information");
glutSetWindow(windowid_main);
}

void printhelp(void) {
glutSetWindow(windowid_help);
glViewport(0, 0, 700, windowheight-80);
glMatrixMode(GL_PROJECTION);
glLoadIdentity();
gluOrtho2D(0.0, 1.0, 0.0, 1.0);
glClearColor(0.3, 0.85, 0.55, 1.0);
glClear(GL_COLOR_BUFFER_BIT);		//Clear screen now
glColor3f(0.5, 0.5 , 0.5);
glBegin(GL_LINE_LOOP);
glVertex2f(0.0, 0.0);
glVertex2f(0.0, .999);
glVertex2f(0.999, 0.999);
glVertex2f(0.999, 0.0);
glEnd();
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f (0.3, 0.9);
drawstring("Key settings - Help screen");
glRasterPos2f(0.05, 0.8);
drawstring("h: This screen          c: clear screen    l: Show license  q: Quit");
glRasterPos2f(0.05, 0.7);
drawstring("a: Signal Analyzer    o: Oscilloscope    m: Multimeter    s: Signal generator");
glRasterPos2f(0.05, 0.6);
drawstring("In analyzer and oscilloscope mode:");
glRasterPos2f(0.05, 0.5);
drawstring("e: Trigger on rising/falling/both edge   1/2/3/4: Enable/disable trigger for channel");
glRasterPos2f(0.05, 0.4);
drawstring("D/d: Increase/decrease trigger delay    left/right: Shift graph    +/-: Zoom in/out" );
glRasterPos2f(0.05, 0.3);
drawstring("Analyzer only:  t: Logic for channel 4        Oscilloscope only: V/v: Trigger value" );
glRasterPos2f(0.05, 0.2);
drawstring("In signal generator mode:");
glRasterPos2f(0.05, 0.1);
drawstring("w: Waveform toggle                         F,+/f,-: Increase/decrease output frequency");
glutSetWindow(windowid_main);
}

void window_size_update(int width, int height) {	//Update window geometry
windowwidth = width;
windowheight = height;

glViewport (0, 0, width, height);
glutSetWindow(windowid_about);
glutReshapeWindow (760, windowheight-50);
glutPositionWindow (windowwidth/2-380, 25);
glutPostRedisplay();
glutSetWindow(windowid_help);
glutReshapeWindow (700, windowheight-80);
glutPositionWindow (windowwidth/2-350, 40);
glutPostRedisplay();
glutSetWindow(m1_windowid_logic);
glutPositionWindow(windowwidth/2-175,windowheight/2-100);
glutSetWindow(windowid_main);
glClear(GL_COLOR_BUFFER_BIT);
screen_text_update();
}

void printabout(void) {
char label[200];
glutSetWindow(windowid_about);
glViewport(0, 0, 760, windowheight-50);
glMatrixMode(GL_PROJECTION);
glLoadIdentity();
gluOrtho2D(0.0, 1.0, 0.0, 1.0);
glClearColor(0.4, 0.55, 0.85, 1.0);
glClear(GL_COLOR_BUFFER_BIT);		//Clear screen now
glColor3f(0.5, 0.5 , 0.5);
glBegin(GL_LINE_LOOP);
glVertex2f(0.0, 0.0);
glVertex2f(0.0, .999);
glVertex2f(0.999, 0.999);
glVertex2f(0.999, 0.0);
glEnd();
glColor3f(0.0, 0.0, 0.0);
glRasterPos2f (0.3, 0.9);
sprintf (label, "Simple signal plot 2.1 (c) 2006 by Malte Marwedel");
drawstring(label);
glRasterPos2f (0.02, 0.8);
sprintf (label, "This program is free software; you can redistribute it and/or modify it under the terms of");
drawstring(label);
glRasterPos2f (0.02, 0.72);
sprintf (label, "the GNU General Public License as published by the Free Software Foundation; either");
drawstring(label);
glRasterPos2f (0.02, 0.64);
sprintf (label, "version 2 of the License, or (at your option) any later version.");
drawstring(label);
glRasterPos2f (0.02, 0.52);
sprintf (label, "This program is distributed in the hope that it will be useful, but WITHOUT ANY");
drawstring(label);
glRasterPos2f (0.02, 0.44);
sprintf (label, "WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS");
drawstring(label);
glRasterPos2f (0.02, 0.36);
sprintf (label, "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.");
drawstring(label);
glRasterPos2f (0.02, 0.24);
sprintf (label, "You should have received a copy of the GNU General Public License  along with this");
drawstring(label);
glRasterPos2f (0.02, 0.16);
sprintf (label, "program. If not, write to ");
drawstring(label);
glRasterPos2f (0.02, 0.08);
sprintf (label, "The Free Software Foundation, Inc. 59 Temple Place, Suite 330  Boston, MA 02111, USA.");
drawstring(label);
glutSetWindow(windowid_main);
}

void drawstring_verysmall(char *text) {		//Draws a string with glut
int nun;
for (nun = 0; nun < strlen(text); nun++) {
  glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10, *(text+nun));
}
}

void drawstring_small(char *text) {		//Draws a string with glut
int nun;
for (nun = 0; nun < strlen(text); nun++) {
  glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, *(text+nun));
}
}

void drawstring(char *text) {		//Draws a string with glut
int nun;
for (nun = 0; nun < strlen(text); nun++) {
  glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, *(text+nun));
}
}
